/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.LegacyTask;
import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedCommandWriter;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import java.time.Duration;
import java.util.function.BiConsumer;

public class ProcessingScheduleServiceImpl
implements ProcessingScheduleService {
    private final ActorControl actorControl;
    private final LegacyTypedCommandWriter commandWriter;

    public ProcessingScheduleServiceImpl(ActorControl actorControl, LegacyTypedCommandWriter legacyTypedCommandWriter) {
        this.actorControl = actorControl;
        this.commandWriter = legacyTypedCommandWriter;
    }

    @Override
    public void runDelayed(Duration delay, Runnable followUpTask) {
        this.scheduleOnActor(() -> this.actorControl.runDelayed(delay, followUpTask));
    }

    @Override
    public <T> void runOnCompletion(ActorFuture<T> precedingTask, BiConsumer<T, Throwable> followUpTask) {
        this.scheduleOnActor(() -> this.actorControl.runOnCompletion(precedingTask, followUpTask));
    }

    @Override
    public <T> void runOnCompletion(ActorFuture<T> precedingTask, LegacyTask followUpTask) {
        this.runOnCompletion(precedingTask, (T ok, Throwable err) -> followUpTask.run(this.commandWriter, this));
    }

    @Override
    public void runDelayed(Duration delay, LegacyTask followUpTask) {
        this.runDelayed(delay, () -> followUpTask.run(this.commandWriter, this));
    }

    private void scheduleOnActor(Runnable task) {
        this.actorControl.submit(task);
    }
}

