/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.LegacyTypedStreamWriterProxy;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordValues;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedResponseWriterImpl;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.LegacyTypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.NoopLegacyTypedStreamWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.KeyGeneratorControls;
import io.camunda.zeebe.engine.state.ZeebeDbState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBatchWriter;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.streamprocessor.ProcessingScheduleServiceImpl;
import io.camunda.zeebe.streamprocessor.StreamProcessorMode;
import io.camunda.zeebe.streamprocessor.state.MutableLastProcessedPositionState;
import java.util.function.BooleanSupplier;

public final class StreamProcessorContext
implements ReadonlyStreamProcessorContext {
    private static final StreamProcessorListener NOOP_LISTENER = processedCommand -> {};
    private final LegacyTypedStreamWriterProxy streamWriterProxy = new LegacyTypedStreamWriterProxy();
    private final NoopLegacyTypedStreamWriter noopTypedStreamWriter = new NoopLegacyTypedStreamWriter();
    private ActorControl actor;
    private LogStream logStream;
    private LogStreamReader logStreamReader;
    private LegacyTypedStreamWriter logStreamWriter = this.noopTypedStreamWriter;
    private LegacyTypedResponseWriterImpl typedResponseWriter;
    private RecordValues recordValues;
    private ZeebeDbState zeebeState;
    private TransactionContext transactionContext;
    private EventApplier eventApplier;
    private BooleanSupplier abortCondition;
    private StreamProcessorListener streamProcessorListener = NOOP_LISTENER;
    private int maxFragmentSize;
    private StreamProcessorMode streamProcessorMode = StreamProcessorMode.PROCESSING;
    private ProcessingScheduleService processingScheduleService;
    private MutableLastProcessedPositionState lastProcessedPositionState;
    private Writers writers;
    private LogStreamBatchWriter logStreamBatchWriter;
    private CommandResponseWriter commandResponseWriter;

    public StreamProcessorContext() {
        this.streamWriterProxy.wrap(this.logStreamWriter);
    }

    public StreamProcessorContext actor(ActorControl actor) {
        this.actor = actor;
        this.processingScheduleService = new ProcessingScheduleServiceImpl(actor, this.streamWriterProxy);
        return this;
    }

    @Override
    public ProcessingScheduleService getScheduleService() {
        return this.processingScheduleService;
    }

    @Override
    public LogStream getLogStream() {
        return this.logStream;
    }

    @Override
    public LegacyTypedStreamWriter getLogStreamWriter() {
        return this.streamWriterProxy;
    }

    @Override
    public Writers getWriters() {
        return this.writers;
    }

    @Override
    public MutableZeebeState getZeebeState() {
        return this.zeebeState;
    }

    @Override
    public int getPartitionId() {
        return this.getLogStream().getPartitionId();
    }

    public MutableLastProcessedPositionState getLastProcessedPositionState() {
        return this.lastProcessedPositionState;
    }

    public StreamProcessorContext listener(StreamProcessorListener streamProcessorListener) {
        this.streamProcessorListener = streamProcessorListener;
        return this;
    }

    public StreamProcessorContext logStream(LogStream logStream) {
        this.logStream = logStream;
        return this;
    }

    public StreamProcessorContext logStreamReader(LogStreamReader logStreamReader) {
        this.logStreamReader = logStreamReader;
        return this;
    }

    public StreamProcessorContext eventCache(RecordValues recordValues) {
        this.recordValues = recordValues;
        return this;
    }

    public StreamProcessorContext zeebeState(ZeebeDbState zeebeState) {
        this.zeebeState = zeebeState;
        return this;
    }

    public StreamProcessorContext lastProcessedPositionState(MutableLastProcessedPositionState lastProcessedPositionState) {
        this.lastProcessedPositionState = lastProcessedPositionState;
        return this;
    }

    public StreamProcessorContext transactionContext(TransactionContext transactionContext) {
        this.transactionContext = transactionContext;
        return this;
    }

    public StreamProcessorContext abortCondition(BooleanSupplier abortCondition) {
        this.abortCondition = abortCondition;
        return this;
    }

    public StreamProcessorContext logStreamWriter(LegacyTypedStreamWriter logStreamWriter) {
        this.logStreamWriter = logStreamWriter;
        return this;
    }

    public StreamProcessorContext commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.commandResponseWriter = commandResponseWriter;
        this.typedResponseWriter = new LegacyTypedResponseWriterImpl(commandResponseWriter, this.getLogStream().getPartitionId());
        return this;
    }

    public LegacyTypedResponseWriterImpl getTypedResponseWriter() {
        return this.typedResponseWriter;
    }

    public StreamProcessorContext maxFragmentSize(int maxFragmentSize) {
        this.maxFragmentSize = maxFragmentSize;
        return this;
    }

    public StreamProcessorContext eventApplier(EventApplier eventApplier) {
        this.eventApplier = eventApplier;
        return this;
    }

    public StreamProcessorContext processorMode(StreamProcessorMode streamProcessorMode) {
        this.streamProcessorMode = streamProcessorMode;
        return this;
    }

    public KeyGeneratorControls getKeyGeneratorControls() {
        return this.zeebeState.getKeyGeneratorControls();
    }

    public ActorControl getActor() {
        return this.actor;
    }

    public LogStreamReader getLogStreamReader() {
        return this.logStreamReader;
    }

    public RecordValues getRecordValues() {
        return this.recordValues;
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public BooleanSupplier getAbortCondition() {
        return this.abortCondition;
    }

    public StreamProcessorListener getStreamProcessorListener() {
        return this.streamProcessorListener;
    }

    public void enableLogStreamWriter() {
        this.streamWriterProxy.wrap(this.logStreamWriter);
    }

    public void disableLogStreamWriter() {
        this.streamWriterProxy.wrap(this.noopTypedStreamWriter);
    }

    public StreamProcessorMode getProcessorMode() {
        return this.streamProcessorMode;
    }

    public void writers(Writers writers) {
        this.writers = writers;
    }

    public void logStreamBatchWriter(LogStreamBatchWriter batchWriter) {
        this.logStreamBatchWriter = batchWriter;
    }

    public LogStreamBatchWriter getLogStreamBatchWriter() {
        return this.logStreamBatchWriter;
    }

    public CommandResponseWriter getCommandResponseWriter() {
        return this.commandResponseWriter;
    }
}

