/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessors;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class BpmnStreamProcessor
implements TypedRecordProcessor<ProcessInstanceRecord> {
    private static final Logger LOGGER = Loggers.PROCESS_PROCESSOR_LOGGER;
    private final BpmnElementContextImpl context = new BpmnElementContextImpl();
    private final SideEffectQueue sideEffectQueue;
    private final ProcessState processState;
    private final BpmnElementProcessors processors;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final TypedRejectionWriter rejectionWriter;
    private final BpmnIncidentBehavior incidentBehavior;

    public BpmnStreamProcessor(BpmnBehaviors bpmnBehaviors, MutableZeebeState zeebeState, Writers writers, SideEffectQueue sideEffectQueue, ProcessEngineMetrics processEngineMetrics) {
        this.processState = zeebeState.getProcessState();
        this.rejectionWriter = writers.rejection();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionGuard = bpmnBehaviors.stateTransitionGuard();
        this.stateTransitionBehavior = new BpmnStateTransitionBehavior(zeebeState.getKeyGenerator(), bpmnBehaviors.stateBehavior(), processEngineMetrics, this::getContainerProcessor, writers);
        this.processors = new BpmnElementProcessors(bpmnBehaviors, this.stateTransitionBehavior);
        this.sideEffectQueue = sideEffectQueue;
    }

    private BpmnElementContainerProcessor<ExecutableFlowElement> getContainerProcessor(BpmnElementType elementType) {
        return this.processors.getContainerProcessor(elementType);
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceRecord> record, Consumer<SideEffectProducer> sideEffect) {
        this.sideEffectQueue.clear();
        sideEffect.accept(this.sideEffectQueue);
        ProcessInstanceIntent intent = (ProcessInstanceIntent)record.getIntent();
        ProcessInstanceRecord recordValue = record.getValue();
        this.context.init(record.getKey(), recordValue, intent);
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        BpmnElementProcessor<ExecutableFlowElement> processor = this.processors.getProcessor(bpmnElementType);
        ExecutableFlowElement element = this.getElement(recordValue, processor);
        this.stateTransitionGuard.isValidStateTransition(this.context, element).ifRightOrLeft(ok -> {
            LOGGER.trace("Process process instance event [context: {}]", (Object)this.context);
            this.processEvent(intent, processor, element);
        }, violation -> this.rejectionWriter.appendRejection(record, RejectionType.INVALID_STATE, violation.getMessage()));
    }

    private void processEvent(ProcessInstanceIntent intent, BpmnElementProcessor<ExecutableFlowElement> processor, ExecutableFlowElement element) {
        switch (intent) {
            case ACTIVATE_ELEMENT: {
                BpmnElementContext activatingContext = this.stateTransitionBehavior.transitionToActivating(this.context);
                this.stateTransitionBehavior.onElementActivating(element, activatingContext).ifRightOrLeft(ok -> processor.onActivate(element, activatingContext), failure -> this.incidentBehavior.createIncident((Failure)failure, activatingContext));
                break;
            }
            case COMPLETE_ELEMENT: {
                BpmnElementContext completingContext = this.stateTransitionBehavior.transitionToCompleting(this.context);
                processor.onComplete(element, completingContext);
                break;
            }
            case TERMINATE_ELEMENT: {
                BpmnElementContext terminatingContext = this.stateTransitionBehavior.transitionToTerminating(this.context);
                processor.onTerminate(element, terminatingContext);
                break;
            }
            default: {
                throw new BpmnProcessingException(this.context, String.format("Expected the processor '%s' to handle the event but the intent '%s' is not supported", processor.getClass(), intent));
            }
        }
    }

    private ExecutableFlowElement getElement(ProcessInstanceRecord recordValue, BpmnElementProcessor<ExecutableFlowElement> processor) {
        return this.processState.getFlowElement(recordValue.getProcessDefinitionKey(), recordValue.getElementIdBuffer(), processor.getType());
    }
}

