/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessMessageSubscriptionCorrelateProcessor
implements TypedRecordProcessor<ProcessMessageSubscriptionRecord> {
    private static final String NO_EVENT_OCCURRED_MESSAGE = "Expected to correlate a process message subscription with element key '%d' and message name '%s', but the subscription is not active anymore";
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to correlate process message subscription with element key '%d' and message name '%s', but no such subscription was found";
    private static final String ALREADY_CLOSING_MESSAGE = "Expected to correlate process message subscription with element key '%d' and message name '%s', but it is already closing";
    private final ProcessMessageSubscriptionState subscriptionState;
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final ProcessState processState;
    private final ElementInstanceState elementInstanceState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final EventHandle eventHandle;

    public ProcessMessageSubscriptionCorrelateProcessor(ProcessMessageSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, MutableZeebeState zeebeState, EventTriggerBehavior eventTriggerBehavior, Writers writers) {
        this.subscriptionState = subscriptionState;
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.processState = zeebeState.getProcessState();
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.eventHandle = new EventHandle(zeebeState.getKeyGenerator(), zeebeState.getEventScopeInstanceState(), writers, this.processState, eventTriggerBehavior);
    }

    @Override
    public void processRecord(TypedRecord<ProcessMessageSubscriptionRecord> command) {
        ProcessMessageSubscriptionRecord record = command.getValue();
        long elementInstanceKey = record.getElementInstanceKey();
        ProcessMessageSubscription subscription = this.subscriptionState.getSubscription(elementInstanceKey, record.getMessageNameBuffer());
        if (subscription == null) {
            this.rejectCommand(command, RejectionType.NOT_FOUND, NO_SUBSCRIPTION_FOUND_MESSAGE);
        } else if (subscription.isClosing()) {
            this.rejectCommand(command, RejectionType.INVALID_STATE, ALREADY_CLOSING_MESSAGE);
        } else {
            ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
            boolean canTriggerElement = this.eventHandle.canTriggerElement(elementInstance, subscription.getRecord().getElementIdBuffer());
            if (!canTriggerElement) {
                this.rejectCommand(command, RejectionType.INVALID_STATE, NO_EVENT_OCCURRED_MESSAGE);
            } else {
                ProcessMessageSubscriptionRecord subscriptionRecord = subscription.getRecord();
                record.setElementId(subscriptionRecord.getElementIdBuffer()).setInterrupting(subscriptionRecord.isInterrupting());
                this.stateWriter.appendFollowUpEvent(subscription.getKey(), (Intent)ProcessMessageSubscriptionIntent.CORRELATED, (RecordValue)record);
                ExecutableFlowElement catchEvent = this.getCatchEvent(elementInstance.getValue(), record.getElementIdBuffer());
                this.eventHandle.activateElement(catchEvent, elementInstanceKey, elementInstance.getValue(), record.getVariablesBuffer());
                this.sendAcknowledgeCommand(record);
            }
        }
    }

    private ExecutableFlowElement getCatchEvent(ProcessInstanceRecord elementRecord, DirectBuffer elementId) {
        return this.processState.getFlowElement(elementRecord.getProcessDefinitionKey(), elementId, ExecutableFlowElement.class);
    }

    private void rejectCommand(TypedRecord<ProcessMessageSubscriptionRecord> command, RejectionType rejectionType, String reasonTemplate) {
        ProcessMessageSubscriptionRecord subscription = command.getValue();
        String reason = String.format(reasonTemplate, subscription.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)subscription.getMessageNameBuffer()));
        this.rejectionWriter.appendRejection(command, rejectionType, reason);
        this.sendRejectionCommand(subscription);
    }

    private void sendAcknowledgeCommand(ProcessMessageSubscriptionRecord subscription) {
        this.subscriptionCommandSender.correlateMessageSubscription(subscription.getSubscriptionPartitionId(), subscription.getProcessInstanceKey(), subscription.getElementInstanceKey(), subscription.getBpmnProcessIdBuffer(), subscription.getMessageNameBuffer());
    }

    private void sendRejectionCommand(ProcessMessageSubscriptionRecord subscription) {
        this.subscriptionCommandSender.rejectCorrelateMessageSubscription(subscription.getProcessInstanceKey(), subscription.getBpmnProcessIdBuffer(), subscription.getMessageKey(), subscription.getMessageNameBuffer(), subscription.getCorrelationKeyBuffer());
    }
}

