/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.api.records.RecordBatch;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.ElementActivationBehavior;
import io.camunda.zeebe.engine.processing.common.EventSubscriptionException;
import io.camunda.zeebe.engine.processing.common.MultipleFlowScopeInstancesFoundException;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffects;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationVariableInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.agrona.DirectBuffer;
import org.agrona.Strings;

public final class ProcessInstanceModificationProcessor
implements TypedRecordProcessor<ProcessInstanceModificationRecord> {
    private static final String ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND = "Expected to modify process instance but no process instance found with key '%d'";
    private static final String ERROR_MESSAGE_ACTIVATE_ELEMENT_NOT_FOUND = "Expected to modify instance of process '%s' but it contains one or more activate instructions with an element that could not be found: '%s'";
    private static final String ERROR_MESSAGE_ACTIVATE_ELEMENT_UNSUPPORTED = "Expected to modify instance of process '%s' but it contains one or more activate instructions for elements that are unsupported: '%s'. %s.";
    private static final String ERROR_MESSAGE_TERMINATE_ELEMENT_INSTANCE_NOT_FOUND = "Expected to modify instance of process '%s' but it contains one or more terminate instructions with an element instance that could not be found: '%s'";
    private static final String ERROR_COMMAND_TOO_LARGE = "Unable to modify process instance with key '%d' as the size exceeds the maximum batch size. Please reduce the size by splitting the modification into multiple commands.";
    private static final String ERROR_MESSAGE_VARIABLE_SCOPE_NOT_FOUND = "Expected to modify instance of process '%s' but it contains one or more variable instructions with a scope element id that could not be found: '%s'";
    private static final String ERROR_MESSAGE_VARIABLE_SCOPE_NOT_FLOW_SCOPE = "Expected to modify instance of process '%s' but it contains one or more variable instructions with a scope element that doesn't belong to the activating element's flow scope. These variables should be set before or after the modification.";
    private static final String ERROR_MESSAGE_MORE_THAN_ONE_FLOW_SCOPE_INSTANCE = "Expected to modify instance of process '%s' but it contains one or more activate instructions for an element that has a flow scope with more than one active instance: '%s'. Can't decide in which instance of the flow scope the element should be activated.";
    private static final String ERROR_MESSAGE_CHILD_PROCESS_INSTANCE_TERMINATED = "Expected to modify instance of process '%s' but the given instructions would terminate the instance. The instance was created by a call activity in the parent process. To terminate this instance please modify the parent process instead.";
    private static final Set<BpmnElementType> UNSUPPORTED_ELEMENT_TYPES = Set.of(BpmnElementType.UNSPECIFIED, BpmnElementType.START_EVENT, BpmnElementType.SEQUENCE_FLOW, BpmnElementType.BOUNDARY_EVENT);
    private static final Set<BpmnElementType> SUPPORTED_ELEMENT_TYPES = Arrays.stream(BpmnElementType.values()).filter(elementType -> !UNSUPPORTED_ELEMENT_TYPES.contains(elementType)).collect(Collectors.toSet());
    private static final Either<Rejection, Object> VALID = Either.right(null);
    private final StateWriter stateWriter;
    private final TypedResponseWriter responseWriter;
    private final ElementInstanceState elementInstanceState;
    private final ProcessState processState;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final TypedRejectionWriter rejectionWriter;
    private final CatchEventBehavior catchEventBehavior;
    private final ElementActivationBehavior elementActivationBehavior;
    private final VariableBehavior variableBehavior;

    public ProcessInstanceModificationProcessor(Writers writers, ElementInstanceState elementInstanceState, ProcessState processState, BpmnBehaviors bpmnBehaviors) {
        this.stateWriter = writers.state();
        this.responseWriter = writers.response();
        this.rejectionWriter = writers.rejection();
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
        this.jobBehavior = bpmnBehaviors.jobBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.catchEventBehavior = bpmnBehaviors.catchEventBehavior();
        this.elementActivationBehavior = bpmnBehaviors.elementActivationBehavior();
        this.variableBehavior = bpmnBehaviors.variableBehavior();
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceModificationRecord> command, Consumer<SideEffectProducer> sideEffect) {
        long commandKey = command.getKey();
        ProcessInstanceModificationRecord value = command.getValue();
        long eventKey = commandKey > -1L ? commandKey : value.getProcessInstanceKey();
        ElementInstance processInstance = this.elementInstanceState.getInstance(value.getProcessInstanceKey());
        if (processInstance == null) {
            String reason = String.format(ERROR_MESSAGE_PROCESS_INSTANCE_NOT_FOUND, eventKey);
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, reason);
            return;
        }
        ProcessInstanceRecord processInstanceRecord = processInstance.getValue();
        DeployedProcess process = this.processState.getProcessByKey(processInstanceRecord.getProcessDefinitionKey());
        Either<Rejection, ?> validationResult = this.validateCommand(command, process);
        if (validationResult.isLeft()) {
            Rejection rejection = (Rejection)validationResult.getLeft();
            this.responseWriter.writeRejectionOnCommand(command, rejection.type(), rejection.reason());
            this.rejectionWriter.appendRejection(command, rejection.type(), rejection.reason());
            return;
        }
        Set requiredKeysForActivation = value.getActivateInstructions().stream().flatMap(instruction -> {
            AbstractFlowElement elementToActivate = process.getProcess().getElementById(instruction.getElementId());
            ElementActivationBehavior.ActivatedElementKeys activatedElementKeys = this.elementActivationBehavior.activateElement(processInstanceRecord, elementToActivate, (elementId, scopeKey) -> this.executeVariableInstruction(BufferUtil.bufferAsString((DirectBuffer)elementId), (Long)scopeKey, processInstance, process, (ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue)instruction));
            activatedElementKeys.getFlowScopeKeys().forEach(arg_0 -> ((ProcessInstanceModificationRecord)value).addActivatedElementInstanceKey(arg_0));
            return activatedElementKeys.getFlowScopeKeys().stream();
        }).collect(Collectors.toSet());
        SideEffectQueue sideEffectQueue = new SideEffectQueue();
        sideEffect.accept(sideEffectQueue);
        value.getTerminateInstructions().forEach(instruction -> {
            ElementInstance elementInstance = this.elementInstanceState.getInstance(instruction.getElementInstanceKey());
            if (elementInstance == null) {
                return;
            }
            long flowScopeKey = elementInstance.getValue().getFlowScopeKey();
            this.terminateElement(elementInstance, sideEffectQueue);
            this.terminateFlowScopes(flowScopeKey, sideEffectQueue, requiredKeysForActivation);
        });
        this.stateWriter.appendFollowUpEvent(eventKey, (Intent)ProcessInstanceModificationIntent.MODIFIED, (RecordValue)value);
        this.responseWriter.writeEventOnCommand(eventKey, (Intent)ProcessInstanceModificationIntent.MODIFIED, (UnpackedObject)value, command);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<ProcessInstanceModificationRecord> typedCommand, Throwable error) {
        if (error instanceof EventSubscriptionException) {
            EventSubscriptionException exception = (EventSubscriptionException)error;
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof MultipleFlowScopeInstancesFoundException) {
            MultipleFlowScopeInstancesFoundException exception = (MultipleFlowScopeInstancesFoundException)error;
            String rejectionReason = ERROR_MESSAGE_MORE_THAN_ONE_FLOW_SCOPE_INSTANCE.formatted(exception.getBpmnProcessId(), exception.getFlowScopeId());
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, rejectionReason);
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, rejectionReason);
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof RecordBatch.ExceededBatchRecordSizeException) {
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, ERROR_COMMAND_TOO_LARGE.formatted(typedCommand.getValue().getProcessInstanceKey()));
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, ERROR_COMMAND_TOO_LARGE.formatted(typedCommand.getValue().getProcessInstanceKey()));
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        if (error instanceof TerminatedChildProcessException) {
            TerminatedChildProcessException exception = (TerminatedChildProcessException)error;
            this.rejectionWriter.appendRejection(typedCommand, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(typedCommand, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private Either<Rejection, ?> validateCommand(TypedRecord<ProcessInstanceModificationRecord> command, DeployedProcess process) {
        ProcessInstanceModificationRecord value = command.getValue();
        List activateInstructions = value.getActivateInstructions();
        List terminateInstructions = value.getTerminateInstructions();
        return this.validateElementExists(process, activateInstructions).flatMap(valid -> this.validateElementSupported(process, activateInstructions)).flatMap(valid -> this.validateElementInstanceExists(process, terminateInstructions)).flatMap(valid -> this.validateVariableScopeExists(process, activateInstructions)).flatMap(valid -> this.validateVariableScopeIsFlowScope(process, activateInstructions)).map(valid -> VALID);
    }

    private Either<Rejection, ?> validateElementExists(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        Set unknownElementIds = activateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getElementId).filter(targetElementId -> process.getProcess().getElementById((String)targetElementId) == null).collect(Collectors.toSet());
        if (unknownElementIds.isEmpty()) {
            return VALID;
        }
        String reason = String.format(ERROR_MESSAGE_ACTIVATE_ELEMENT_NOT_FOUND, BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", unknownElementIds));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateElementSupported(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        return ProcessInstanceModificationProcessor.validateElementsDoNotBelongToEventBasedGateway(process, activateInstructions).flatMap(valid -> this.validateElementsNotInsideMultiInstance(process, activateInstructions)).flatMap(valid -> this.validateElementsHaveSupportedType(process, activateInstructions)).map(valid -> VALID);
    }

    private static Either<Rejection, ?> validateElementsDoNotBelongToEventBasedGateway(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        List<String> elementIdsConnectedToEventBasedGateway = activateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getElementId).distinct().filter(elementId -> {
            ExecutableCatchEventElement event;
            AbstractFlowElement element = process.getProcess().getElementById((String)elementId);
            return element instanceof ExecutableCatchEventElement && (event = (ExecutableCatchEventElement)element).isConnectedToEventBasedGateway();
        }).toList();
        if (elementIdsConnectedToEventBasedGateway.isEmpty()) {
            return VALID;
        }
        String reason = ERROR_MESSAGE_ACTIVATE_ELEMENT_UNSUPPORTED.formatted(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", elementIdsConnectedToEventBasedGateway), "The activation of events belonging to an event-based gateway is not supported");
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateElementsNotInsideMultiInstance(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        List<String> elementsInsideMultiInstance = activateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getElementId).distinct().filter(elementId -> this.isInsideMultiInstanceBody(process, BufferUtil.wrapString((String)elementId))).toList();
        if (elementsInsideMultiInstance.isEmpty()) {
            return VALID;
        }
        String reason = String.format(ERROR_MESSAGE_ACTIVATE_ELEMENT_UNSUPPORTED, BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", elementsInsideMultiInstance), "The activation of elements inside a multi-instance subprocess is not supported");
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateElementsHaveSupportedType(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        List<AbstractFlowElement> elementsWithUnsupportedElementType = activateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getElementId).distinct().map(elementId -> process.getProcess().getElementById((String)elementId)).filter(element -> UNSUPPORTED_ELEMENT_TYPES.contains(element.getElementType())).toList();
        if (elementsWithUnsupportedElementType.isEmpty()) {
            return VALID;
        }
        String usedUnsupportedElementIds = elementsWithUnsupportedElementType.stream().map(AbstractFlowElement::getId).map(BufferUtil::bufferAsString).collect(Collectors.joining("', '"));
        String usedUnsupportedElementTypes = elementsWithUnsupportedElementType.stream().map(AbstractFlowElement::getElementType).map(Objects::toString).distinct().collect(Collectors.joining("', '"));
        String reason = ERROR_MESSAGE_ACTIVATE_ELEMENT_UNSUPPORTED.formatted(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), usedUnsupportedElementIds, "The activation of elements with type '%s' is not supported. Supported element types are: %s".formatted(usedUnsupportedElementTypes, SUPPORTED_ELEMENT_TYPES));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private boolean isInsideMultiInstanceBody(DeployedProcess process, DirectBuffer elementId) {
        AbstractFlowElement element = process.getProcess().getElementById(elementId);
        if (element.getFlowScope() == null) {
            return false;
        }
        AbstractFlowElement flowScope = process.getProcess().getElementById(element.getFlowScope().getId());
        return flowScope.getElementType() == BpmnElementType.MULTI_INSTANCE_BODY || this.isInsideMultiInstanceBody(process, flowScope.getId());
    }

    private Either<Rejection, ?> validateElementInstanceExists(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> terminateInstructions) {
        List<Long> unknownElementInstanceKeys = terminateInstructions.stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue::getElementInstanceKey).distinct().filter(instanceKey -> this.elementInstanceState.getInstance((long)instanceKey) == null).toList();
        if (unknownElementInstanceKeys.isEmpty()) {
            return VALID;
        }
        String reason = String.format(ERROR_MESSAGE_TERMINATE_ELEMENT_INSTANCE_NOT_FOUND, BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), unknownElementInstanceKeys.stream().map(Objects::toString).collect(Collectors.joining("', '")));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateVariableScopeExists(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        Set unknownScopeElementIds = activateInstructions.stream().flatMap(instruction -> instruction.getVariableInstructions().stream()).map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue::getElementId).filter(Predicate.not(String::isEmpty)).filter(scopeElementId -> process.getProcess().getElementById((String)scopeElementId) == null).collect(Collectors.toSet());
        if (unknownScopeElementIds.isEmpty()) {
            return VALID;
        }
        String reason = ERROR_MESSAGE_VARIABLE_SCOPE_NOT_FOUND.formatted(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()), String.join((CharSequence)"', '", unknownScopeElementIds));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private Either<Rejection, ?> validateVariableScopeIsFlowScope(DeployedProcess process, List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> activateInstructions) {
        Set nonFlowScopeIds = activateInstructions.stream().flatMap(instruction -> {
            String elementId = instruction.getElementId();
            AbstractFlowElement elementToActivate = process.getProcess().getElementById(elementId);
            return instruction.getVariableInstructions().stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue::getElementId).filter(Predicate.not(String::isEmpty)).filter(Predicate.not(elementId::equals)).filter(scopeElementId -> !this.isFlowScopeOfElement(elementToActivate, (String)scopeElementId));
        }).collect(Collectors.toSet());
        if (nonFlowScopeIds.isEmpty()) {
            return VALID;
        }
        String reason = ERROR_MESSAGE_VARIABLE_SCOPE_NOT_FLOW_SCOPE.formatted(BufferUtil.bufferAsString((DirectBuffer)process.getBpmnProcessId()));
        return Either.left((Object)new Rejection(RejectionType.INVALID_ARGUMENT, reason));
    }

    private boolean isFlowScopeOfElement(ExecutableFlowElement element, String targetElementId) {
        for (ExecutableFlowElement flowScope = element.getFlowScope(); flowScope != null; flowScope = flowScope.getFlowScope()) {
            String flowScopeId = BufferUtil.bufferAsString((DirectBuffer)flowScope.getId());
            if (!flowScopeId.equals(targetElementId)) continue;
            return true;
        }
        return false;
    }

    public void executeVariableInstruction(String elementId, Long scopeKey, ElementInstance processInstance, DeployedProcess process, ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue activate) {
        activate.getVariableInstructions().stream().filter(instruction -> instruction.getElementId().equals(elementId) || Strings.isEmpty((String)instruction.getElementId()) && elementId.equals(processInstance.getValue().getBpmnProcessId())).map(instruction -> {
            if (instruction instanceof ProcessInstanceModificationVariableInstruction) {
                ProcessInstanceModificationVariableInstruction vi = (ProcessInstanceModificationVariableInstruction)instruction;
                return vi.getVariablesBuffer();
            }
            throw new UnsupportedOperationException("Expected variable instruction of type %s, but was %s".formatted(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue.class.getName(), instruction.getClass().getName()));
        }).forEach(variableDocument -> this.variableBehavior.mergeLocalDocument(scopeKey, process.getKey(), processInstance.getKey(), process.getBpmnProcessId(), (DirectBuffer)variableDocument));
    }

    private void terminateElement(ElementInstance elementInstance, SideEffects sideEffects) {
        long elementInstanceKey = elementInstance.getKey();
        ProcessInstanceRecord elementInstanceRecord = elementInstance.getValue();
        BpmnElementType elementType = elementInstance.getValue().getBpmnElementType();
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_TERMINATING, (RecordValue)elementInstanceRecord);
        this.jobBehavior.cancelJob(elementInstance);
        this.incidentBehavior.resolveIncidents(elementInstanceKey);
        this.catchEventBehavior.unsubscribeFromEvents(elementInstanceKey, sideEffects);
        if (elementType == BpmnElementType.EVENT_SUB_PROCESS || elementType == BpmnElementType.SUB_PROCESS || elementType == BpmnElementType.PROCESS || elementType == BpmnElementType.MULTI_INSTANCE_BODY) {
            this.elementInstanceState.getChildren(elementInstanceKey).stream().filter(ElementInstance::canTerminate).forEach(childInstance -> this.terminateElement((ElementInstance)((Object)childInstance), sideEffects));
        } else if (elementType == BpmnElementType.CALL_ACTIVITY) {
            ElementInstance calledActivityElementInstance = this.elementInstanceState.getInstance(elementInstance.getCalledChildInstanceKey());
            this.terminateElement(calledActivityElementInstance, sideEffects);
        }
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_TERMINATED, (RecordValue)elementInstanceRecord);
    }

    private void terminateFlowScopes(long elementInstanceKey, SideEffects sideEffects, Set<Long> requiredKeysForActivation) {
        ElementInstance currentElementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
        while (this.canTerminateElementInstance(currentElementInstance, requiredKeysForActivation)) {
            ProcessInstanceRecord currentElementInstanceRecord = currentElementInstance.getValue();
            if (currentElementInstanceRecord.getBpmnElementType() == BpmnElementType.PROCESS && currentElementInstanceRecord.hasParentProcess()) {
                throw new TerminatedChildProcessException(ERROR_MESSAGE_CHILD_PROCESS_INSTANCE_TERMINATED.formatted(currentElementInstanceRecord.getBpmnProcessId()));
            }
            long flowScopeKey = currentElementInstance.getValue().getFlowScopeKey();
            this.terminateElement(currentElementInstance, sideEffects);
            currentElementInstance = this.elementInstanceState.getInstance(flowScopeKey);
        }
    }

    private boolean canTerminateElementInstance(ElementInstance elementInstance, Set<Long> requiredKeysForActivation) {
        return elementInstance != null && elementInstance.getNumberOfActiveElementInstances() == 0 && elementInstance.getActiveSequenceFlows() == 0L && !requiredKeysForActivation.contains(elementInstance.getKey());
    }

    private record Rejection(RejectionType type, String reason) {
    }

    private static class TerminatedChildProcessException
    extends RuntimeException {
        TerminatedChildProcessException(String message) {
            super(message);
        }
    }
}

