/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.intent.JobIntent;

final class JobCreatedApplier
implements TypedEventApplier<JobIntent, JobRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final MutableJobState jobState;

    JobCreatedApplier(MutableZeebeState state) {
        this.jobState = state.getJobState();
        this.elementInstanceState = state.getElementInstanceState();
    }

    @Override
    public void applyState(long key, JobRecord value) {
        ElementInstance elementInstance;
        this.jobState.create(key, value);
        long elementInstanceKey = value.getElementInstanceKey();
        if (elementInstanceKey > 0L && (elementInstance = this.elementInstanceState.getInstance(elementInstanceKey)) != null) {
            elementInstance.setJobKey(key);
            this.elementInstanceState.updateInstance(elementInstance);
        }
    }
}

