/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.distribute;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.deployment.MessageStartEventSubscriptionManager;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.MessageStartEventSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;

public final class DeploymentDistributeProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    private final MessageStartEventSubscriptionManager messageStartEventSubscriptionManager;
    private final StateWriter stateWriter;
    private final DeploymentDistributionCommandSender deploymentDistributionCommandSender;

    public DeploymentDistributeProcessor(ProcessState processState, MessageStartEventSubscriptionState messageStartEventSubscriptionState, DeploymentDistributionCommandSender deploymentDistributionCommandSender, Writers writers, KeyGenerator keyGenerator) {
        this.deploymentDistributionCommandSender = deploymentDistributionCommandSender;
        this.messageStartEventSubscriptionManager = new MessageStartEventSubscriptionManager(processState, messageStartEventSubscriptionState, keyGenerator);
        this.stateWriter = writers.state();
    }

    @Override
    public void processRecord(TypedRecord<DeploymentRecord> event) {
        DeploymentRecord deploymentEvent = event.getValue();
        long deploymentKey = event.getKey();
        this.stateWriter.appendFollowUpEvent(deploymentKey, (Intent)DeploymentIntent.DISTRIBUTED, (RecordValue)deploymentEvent);
        this.deploymentDistributionCommandSender.completeOnPartition(deploymentKey);
        this.messageStartEventSubscriptionManager.tryReOpenMessageStartEventSubscription(deploymentEvent, this.stateWriter);
    }
}

