/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.scheduled;

import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.api.Task;
import io.camunda.zeebe.engine.api.TaskResult;
import io.camunda.zeebe.engine.api.TaskResultBuilder;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.time.Duration;
import java.util.function.Function;

public final class DueDateChecker
implements StreamProcessorLifecycleAware {
    private ScheduleDelayed scheduleService;
    private final boolean scheduleAsync;
    private boolean checkerRunning;
    private boolean shouldRescheduleChecker;
    private long nextDueDate = -1L;
    private final long timerResolution;
    private final Function<TaskResultBuilder, Long> nextDueDateSupplier;
    private final TriggerEntitiesTask triggerEntitiesTask;

    public DueDateChecker(long timerResolution, boolean scheduleAsync, Function<TaskResultBuilder, Long> nextDueDateFunction) {
        this.timerResolution = timerResolution;
        this.scheduleAsync = scheduleAsync;
        this.nextDueDateSupplier = nextDueDateFunction;
        this.triggerEntitiesTask = new TriggerEntitiesTask();
    }

    public void schedule(long dueDate) {
        Duration delay = this.calculateDelayForNextRun(dueDate);
        if (this.shouldRescheduleChecker) {
            if (!this.checkerRunning) {
                this.scheduleService.runDelayed(delay, this.triggerEntitiesTask);
                this.nextDueDate = dueDate;
                this.checkerRunning = true;
            } else if (this.nextDueDate - dueDate > this.timerResolution) {
                this.scheduleService.runDelayed(delay, this.triggerEntitiesTask);
                this.nextDueDate = dueDate;
            }
        }
    }

    private void scheduleTriggerEntitiesTask() {
        if (this.shouldRescheduleChecker) {
            this.scheduleService.runDelayed(Duration.ZERO, this.triggerEntitiesTask);
        } else {
            this.checkerRunning = false;
        }
    }

    private Duration calculateDelayForNextRun(long dueDate) {
        return Duration.ofMillis(Math.max(dueDate - ActorClock.currentTimeMillis(), this.timerResolution));
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext processingContext) {
        ProcessingScheduleService scheduleService = processingContext.getScheduleService();
        this.scheduleService = this.scheduleAsync ? scheduleService::runDelayedAsync : scheduleService::runDelayed;
        this.shouldRescheduleChecker = true;
        this.scheduleTriggerEntitiesTask();
    }

    @Override
    public void onPaused() {
        this.shouldRescheduleChecker = false;
        this.nextDueDate = -1L;
    }

    @Override
    public void onResumed() {
        this.shouldRescheduleChecker = true;
        if (!this.checkerRunning) {
            this.scheduleTriggerEntitiesTask();
        }
    }

    private final class TriggerEntitiesTask
    implements Task {
        private TriggerEntitiesTask() {
        }

        @Override
        public TaskResult execute(TaskResultBuilder taskResultBuilder) {
            if (DueDateChecker.this.shouldRescheduleChecker) {
                DueDateChecker.this.nextDueDate = DueDateChecker.this.nextDueDateSupplier.apply(taskResultBuilder);
                if (DueDateChecker.this.nextDueDate > 0L) {
                    Duration delay = DueDateChecker.this.calculateDelayForNextRun(DueDateChecker.this.nextDueDate);
                    DueDateChecker.this.scheduleService.runDelayed(delay, this);
                    DueDateChecker.this.checkerRunning = true;
                } else {
                    DueDateChecker.this.checkerRunning = false;
                }
            } else {
                DueDateChecker.this.checkerRunning = false;
            }
            return taskResultBuilder.build();
        }
    }

    @FunctionalInterface
    static interface ScheduleDelayed {
        public void runDelayed(Duration var1, Task var2);
    }
}

