/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.processing;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.metrics.BannedInstanceMetrics;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.mutable.MutableBannedInstanceState;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class DbBannedInstanceState
implements MutableBannedInstanceState {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final String BAN_INSTANCE_MESSAGE = "Ban process instance {}, due to previous errors.";
    private final ColumnFamily<DbLong, DbNil> bannedInstanceColumnFamily;
    private final DbLong processInstanceKey = new DbLong();
    private final BannedInstanceMetrics bannedInstanceMetrics;

    public DbBannedInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.bannedInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.BANNED_INSTANCE, transactionContext, (DbKey)this.processInstanceKey, (DbValue)DbNil.INSTANCE);
        this.bannedInstanceMetrics = new BannedInstanceMetrics(partitionId);
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        AtomicInteger counter = new AtomicInteger(0);
        this.bannedInstanceColumnFamily.forEach(ignore -> counter.getAndIncrement());
        this.bannedInstanceMetrics.setBannedInstanceCounter(counter.get());
    }

    private void banInstance(long key) {
        if (key >= 0L) {
            LOG.warn(BAN_INSTANCE_MESSAGE, (Object)key);
            this.processInstanceKey.wrapLong(key);
            this.bannedInstanceColumnFamily.upsert((DbKey)this.processInstanceKey, (DbValue)DbNil.INSTANCE);
            this.bannedInstanceMetrics.countBannedInstance();
        }
    }

    private boolean isBanned(long key) {
        this.processInstanceKey.wrapLong(key);
        return this.bannedInstanceColumnFamily.exists((DbKey)this.processInstanceKey);
    }

    @Override
    public boolean isBanned(TypedRecord record) {
        long processInstanceKey;
        Object value = record.getValue();
        if (value instanceof ProcessInstanceRelated && (processInstanceKey = ((ProcessInstanceRelated)value).getProcessInstanceKey()) >= 0L) {
            return this.isBanned(processInstanceKey);
        }
        return false;
    }

    @Override
    public boolean tryToBanInstance(TypedRecord<?> typedRecord, Consumer<Long> onBanningInstance) {
        Object value;
        Intent intent = typedRecord.getIntent();
        if (DbBannedInstanceState.shouldBeBanned(intent) && (value = typedRecord.getValue()) instanceof ProcessInstanceRelated) {
            long processInstanceKey = ((ProcessInstanceRelated)value).getProcessInstanceKey();
            this.banInstance(processInstanceKey);
            onBanningInstance.accept(processInstanceKey);
        }
        return false;
    }

    @Override
    public void banProcessInstance(long processInstanceKey) {
        this.banInstance(processInstanceKey);
    }

    public static boolean shouldBeBanned(Intent intent) {
        if (intent instanceof ProcessInstanceRelatedIntent) {
            ProcessInstanceRelatedIntent processInstanceRelatedIntent = (ProcessInstanceRelatedIntent)intent;
            return processInstanceRelatedIntent.shouldBanInstanceOnError();
        }
        return false;
    }
}

