/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.query;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.ProcessingDbState;
import io.camunda.zeebe.engine.state.QueryService;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class StateQueryService
implements QueryService {
    private volatile boolean isClosed;
    private ProcessingState state;
    private final ZeebeDb<ZbColumnFamilies> zeebeDb;

    public StateQueryService(ZeebeDb<ZbColumnFamilies> zeebeDb) {
        this.zeebeDb = zeebeDb;
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    @Override
    public Optional<DirectBuffer> getBpmnProcessIdForProcess(long key) {
        this.ensureServiceIsOpened();
        return Optional.ofNullable(this.state.getProcessState().getProcessByKey(key)).map(DeployedProcess::getBpmnProcessId);
    }

    @Override
    public Optional<DirectBuffer> getBpmnProcessIdForProcessInstance(long key) {
        this.ensureServiceIsOpened();
        return Optional.ofNullable(this.state.getElementInstanceState().getInstance(key)).map(ElementInstance::getValue).map(ProcessInstanceRecord::getBpmnProcessIdBuffer);
    }

    @Override
    public Optional<DirectBuffer> getBpmnProcessIdForJob(long key) {
        this.ensureServiceIsOpened();
        return Optional.ofNullable(this.state.getJobState().getJob(key)).map(JobRecord::getBpmnProcessIdBuffer);
    }

    private void ensureServiceIsOpened() {
        if (this.isClosed) {
            throw new QueryService.ClosedServiceException();
        }
        if (this.state == null) {
            this.state = new ProcessingDbState(1, this.zeebeDb, this.zeebeDb.createContext(), null, new EngineConfiguration());
        }
    }
}

