/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.engine.api.PostCommitTask;
import io.camunda.zeebe.engine.api.ProcessingResponse;
import io.camunda.zeebe.engine.api.ProcessingResult;
import io.camunda.zeebe.engine.api.TaskResult;
import io.camunda.zeebe.engine.api.records.ImmutableRecordBatch;
import io.camunda.zeebe.streamprocessor.BufferedProcessingResultBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

final class BufferedResult
implements ProcessingResult,
TaskResult {
    private final List<PostCommitTask> postCommitTasks;
    private final ImmutableRecordBatch immutableRecordBatch;
    private final BufferedProcessingResultBuilder.ProcessingResponseImpl processingResponse;

    BufferedResult(ImmutableRecordBatch immutableRecordBatch, BufferedProcessingResultBuilder.ProcessingResponseImpl processingResponse, List<PostCommitTask> postCommitTasks) {
        this.postCommitTasks = new ArrayList<PostCommitTask>(postCommitTasks);
        this.processingResponse = processingResponse;
        this.immutableRecordBatch = immutableRecordBatch;
    }

    @Override
    public ImmutableRecordBatch getRecordBatch() {
        return this.immutableRecordBatch;
    }

    @Override
    public Optional<ProcessingResponse> getProcessingResponse() {
        return Optional.ofNullable(this.processingResponse);
    }

    @Override
    public boolean executePostCommitTasks() {
        boolean aggregatedResult = true;
        for (PostCommitTask task : this.postCommitTasks) {
            try {
                aggregatedResult = aggregatedResult && task.flush();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return aggregatedResult;
    }

    @Override
    public boolean isEmpty() {
        return this.getProcessingResponse().isEmpty() && this.getRecordBatch().entries().isEmpty() && this.postCommitTasks.isEmpty();
    }
}

