/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.state.instance.ElementInstance;

public final class EventSubProcessProcessor
implements BpmnElementContainerProcessor<ExecutableFlowElementContainer> {
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnIncidentBehavior incidentBehavior;

    public EventSubProcessProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableFlowElementContainer> getType() {
        return ExecutableFlowElementContainer.class;
    }

    @Override
    public void onActivate(ExecutableFlowElementContainer element, BpmnElementContext activating) {
        this.variableMappingBehavior.applyInputMappings(activating, element).ifRightOrLeft(ok -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(activating);
            this.stateTransitionBehavior.activateChildInstance(activated, element.getStartEvents().get(0));
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, activating));
    }

    @Override
    public void onComplete(ExecutableFlowElementContainer element, BpmnElementContext completing) {
        this.variableMappingBehavior.applyOutputMappings(completing, element).flatMap(ok -> this.stateTransitionBehavior.transitionToCompleted(element, completing)).ifLeft(failure -> this.incidentBehavior.createIncident((Failure)failure, completing));
    }

    @Override
    public void onTerminate(ExecutableFlowElementContainer element, BpmnElementContext terminating) {
        this.incidentBehavior.resolveIncidents(terminating);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(terminating);
        if (noActiveChildInstances) {
            this.onChildTerminated(element, terminating, (BpmnElementContext)null);
        }
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        if (this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        ElementInstance flowScopeInstance = this.stateBehavior.getElementInstance(flowScopeContext);
        if (childContext == null || this.stateBehavior.canBeTerminated(childContext)) {
            if (flowScopeInstance.isTerminating()) {
                BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(flowScopeContext);
                this.stateTransitionBehavior.onElementTerminated(element, terminated);
            } else if (flowScopeInstance.isActive()) {
                this.stateTransitionBehavior.completeElement(flowScopeContext);
            }
        }
    }
}

