/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutablePendingMessageSubscriptionState;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.scheduler.clock.ActorClock;

public final class PendingMessageSubscriptionChecker
implements Runnable {
    private final SubscriptionCommandSender commandSender;
    private final MutablePendingMessageSubscriptionState transientState;
    private final long subscriptionTimeout;

    public PendingMessageSubscriptionChecker(SubscriptionCommandSender commandSender, MutablePendingMessageSubscriptionState transientState, long subscriptionTimeout) {
        this.commandSender = commandSender;
        this.transientState = transientState;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    @Override
    public void run() {
        this.transientState.visitSubscriptionBefore(ActorClock.currentTimeMillis() - this.subscriptionTimeout, this::sendCommand);
    }

    private boolean sendCommand(MessageSubscription subscription) {
        MessageSubscriptionRecord record = subscription.getRecord();
        boolean success = this.commandSender.correlateProcessMessageSubscription(record.getProcessInstanceKey(), record.getElementInstanceKey(), record.getBpmnProcessIdBuffer(), record.getMessageNameBuffer(), record.getMessageKey(), record.getVariablesBuffer(), record.getCorrelationKeyBuffer());
        if (success) {
            long sentTime = ActorClock.currentTimeMillis();
            this.transientState.updateCommandSentTime(subscription.getRecord(), sentTime);
        }
        return success;
    }
}

