/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.distribute;

import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentDistributionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.DirectBuffer;

public final class DeploymentDistributionBehavior {
    private final DeploymentDistributionRecord deploymentDistributionRecord = new DeploymentDistributionRecord();
    private final DeploymentRecord emptyDeploymentRecord = new DeploymentRecord();
    private final List<Integer> otherPartitions;
    private final DeploymentDistributionCommandSender deploymentDistributionCommandSender;
    private final StateWriter stateWriter;

    public DeploymentDistributionBehavior(Writers writers, int partitionsCount, DeploymentDistributionCommandSender deploymentDistributionCommandSender) {
        this.otherPartitions = IntStream.range(1, 1 + partitionsCount).filter(partition -> partition != 1).boxed().collect(Collectors.toList());
        this.deploymentDistributionCommandSender = deploymentDistributionCommandSender;
        this.stateWriter = writers.state();
    }

    public void distributeDeployment(DeploymentRecord deploymentEvent, long key, SideEffectQueue sideEffectQueue) {
        DirectBuffer copiedDeploymentBuffer = BufferUtil.createCopy((BufferWriter)deploymentEvent);
        this.otherPartitions.forEach(partitionId -> {
            this.deploymentDistributionRecord.setPartition(partitionId.intValue());
            this.stateWriter.appendFollowUpEvent(key, (Intent)DeploymentDistributionIntent.DISTRIBUTING, (RecordValue)this.deploymentDistributionRecord);
            sideEffectQueue.add(() -> {
                this.distributeDeploymentToPartition(key, (int)partitionId, copiedDeploymentBuffer);
                return true;
            });
        });
        if (this.otherPartitions.isEmpty()) {
            this.stateWriter.appendFollowUpEvent(key, (Intent)DeploymentIntent.FULLY_DISTRIBUTED, (RecordValue)this.emptyDeploymentRecord);
        }
    }

    public void distributeDeploymentToPartition(long key, int partitionId, DirectBuffer copiedDeploymentBuffer) {
        DeploymentRecord deploymentRecord = new DeploymentRecord();
        deploymentRecord.wrap(copiedDeploymentBuffer);
        this.deploymentDistributionCommandSender.distributeToPartition(key, partitionId, deploymentRecord);
    }
}

