/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.timer.CronTimer;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.camunda.zeebe.model.bpmn.util.time.TimeDateTimer;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import java.time.format.DateTimeParseException;

public final class CatchEventTransformer
implements ModelElementTransformer<CatchEvent> {
    @Override
    public Class<CatchEvent> getType() {
        return CatchEvent.class;
    }

    @Override
    public void transform(CatchEvent element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableCatchEventElement executableElement = process.getElementById(element.getId(), ExecutableCatchEventElement.class);
        if (!element.getEventDefinitions().isEmpty()) {
            this.transformEventDefinition(element, context, executableElement);
        }
    }

    private void transformEventDefinition(CatchEvent element, TransformContext context, ExecutableCatchEventElement executableElement) {
        EventDefinition eventDefinition = (EventDefinition)element.getEventDefinitions().iterator().next();
        if (eventDefinition instanceof MessageEventDefinition) {
            this.transformMessageEventDefinition(context, executableElement, (MessageEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof TimerEventDefinition) {
            ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
            TimerEventDefinition timerDefinition = (TimerEventDefinition)eventDefinition;
            this.transformTimerEventDefinition(expressionLanguage, executableElement, timerDefinition);
        } else if (eventDefinition instanceof ErrorEventDefinition) {
            this.transformErrorEventDefinition(context, executableElement, (ErrorEventDefinition)eventDefinition);
        }
    }

    private void transformMessageEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, MessageEventDefinition messageEventDefinition) {
        Message message = messageEventDefinition.getMessage();
        ExecutableMessage executableMessage = context.getMessage(message.getId());
        executableElement.setMessage(executableMessage);
    }

    private void transformTimerEventDefinition(ExpressionLanguage expressionLanguage, ExecutableCatchEventElement executableElement, TimerEventDefinition timerEventDefinition) {
        if (timerEventDefinition.getTimeDuration() != null) {
            String duration = timerEventDefinition.getTimeDuration().getTextContent();
            Expression expression = expressionLanguage.parseExpression(duration);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> expressionProcessor.evaluateIntervalExpression(expression, (long)scopeKey).map(interval -> new RepeatingInterval(1, interval)));
        } else if (timerEventDefinition.getTimeCycle() != null) {
            String cycle = timerEventDefinition.getTimeCycle().getTextContent();
            Expression expression = expressionLanguage.parseExpression(cycle);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> {
                try {
                    return expressionProcessor.evaluateStringExpression(expression, (long)scopeKey).map(text -> {
                        if (text.startsWith("R")) {
                            return RepeatingInterval.parse((String)text);
                        }
                        return CronTimer.parse(text);
                    });
                }
                catch (DateTimeParseException e) {
                    return Either.left((Object)new Failure(e.getMessage(), ErrorType.EXTRACT_VALUE_ERROR, (long)scopeKey));
                }
            });
        } else if (timerEventDefinition.getTimeDate() != null) {
            String timeDate = timerEventDefinition.getTimeDate().getTextContent();
            Expression expression = expressionLanguage.parseExpression(timeDate);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> expressionProcessor.evaluateDateTimeExpression(expression, (Long)scopeKey).map(TimeDateTimer::new));
        }
    }

    private void transformErrorEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, ErrorEventDefinition errorEventDefinition) {
        Error error = errorEventDefinition.getError();
        ExecutableError executableError = context.getError(error.getId());
        executableElement.setError(executableError);
    }
}

