/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.api.records;

import io.camunda.zeebe.engine.api.records.ImmutableRecordBatch;
import io.camunda.zeebe.engine.api.records.ImmutableRecordBatchEntry;
import io.camunda.zeebe.engine.api.records.MutableRecordBatch;
import io.camunda.zeebe.engine.api.records.RecordBatchEntry;
import io.camunda.zeebe.engine.api.records.RecordBatchSizePredicate;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

public final class RecordBatch
implements MutableRecordBatch {
    final List<ImmutableRecordBatchEntry> recordBatchEntries = new ArrayList<ImmutableRecordBatchEntry>();
    private int batchSize;
    private final RecordBatchSizePredicate recordBatchSizePredicate;

    public RecordBatch(RecordBatchSizePredicate recordBatchSizePredicate) {
        this.recordBatchSizePredicate = recordBatchSizePredicate;
    }

    public static ImmutableRecordBatch empty() {
        return new RecordBatch((c, s) -> false);
    }

    @Override
    public Either<RuntimeException, Void> appendRecord(long key, int sourceIndex, RecordType recordType, Intent intent, RejectionType rejectionType, String rejectionReason, ValueType valueType, BufferWriter valueWriter) {
        RecordBatchEntry recordBatchEntry = RecordBatchEntry.createEntry(key, sourceIndex, recordType, intent, rejectionType, rejectionReason, valueType, valueWriter);
        int entryLength = recordBatchEntry.getLength();
        if (!this.recordBatchSizePredicate.test(this.recordBatchEntries.size() + 1, this.batchSize + entryLength)) {
            return Either.left((Object)new ExceededBatchRecordSizeException(recordBatchEntry, entryLength, this.recordBatchEntries.size(), this.batchSize));
        }
        this.recordBatchEntries.add(recordBatchEntry);
        this.batchSize += entryLength;
        return Either.right(null);
    }

    @Override
    public boolean canAppendRecordOfLength(int recordLength) {
        return this.recordBatchSizePredicate.test(this.recordBatchEntries.size() + 1, this.batchSize + recordLength);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Iterator<ImmutableRecordBatchEntry> iterator() {
        return this.recordBatchEntries.iterator();
    }

    @Override
    public void forEach(Consumer<? super ImmutableRecordBatchEntry> action) {
        this.recordBatchEntries.forEach(action);
    }

    @Override
    public Spliterator<ImmutableRecordBatchEntry> spliterator() {
        return this.recordBatchEntries.spliterator();
    }

    public static class ExceededBatchRecordSizeException
    extends RuntimeException {
        public ExceededBatchRecordSizeException(RecordBatchEntry recordBatchEntry, int entryLength, int recordBatchEntriesSize, int batchSize) {
            super("Can't append entry: '%s' with size: %d this would exceed the maximum batch size. [ currentBatchEntryCount: %d, currentBatchSize: %d]".formatted(StringUtil.limitString((String)recordBatchEntry.toString(), (int)1024), entryLength, recordBatchEntriesSize, batchSize));
        }
    }
}

