/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.prometheus.client.Counter;

public final class ProcessEngineMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String ORGANIZATION_ID_LABEL = "organizationId";
    private static final String PARTITION_LABEL = "partition";
    private static final String ACTION_LABEL = "action";
    static final Counter EVALUATED_DMN_ELEMENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("evaluated_dmn_elements_total")).help("Number of evaluated DMN elements including required decisions")).labelNames(new String[]{"organizationId", "action", "partition"})).register();
    private static final String TYPE_LABEL = "type";
    static final Counter EXECUTED_INSTANCES = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("executed_instances_total")).help("Number of executed (root) process instances")).labelNames(new String[]{"organizationId", "type", "action", "partition"})).register();
    private static final String ORGANIZATION_ID = System.getenv().getOrDefault("CAMUNDA_CLOUD_ORGANIZATION_ID", "null");
    private static final String ACTION_ACTIVATED = "activated";
    private static final String ACTION_COMPLETED = "completed";
    private static final String ACTION_TERMINATED = "terminated";
    private static final String ACTION_EVALUATED_SUCCESSFULLY = "evaluated_successfully";
    private static final String ACTION_EVALUATED_FAILED = "evaluated_failed";
    private static final Counter ELEMENT_INSTANCE_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("element_instance_events_total")).help("Number of process element instance events")).labelNames(new String[]{"action", "type", "partition"})).register();
    private static final String CREATION_MODE_LABEL = "creation_mode";
    static final Counter CREATED_PROCESS_INSTANCES = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("process_instance_creations_total")).help("Number of created (root) process instances")).labelNames(new String[]{"partition", "creation_mode"})).register();
    private final String partitionIdLabel;

    public ProcessEngineMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    public void processInstanceCreated(ProcessInstanceCreationRecord instanceCreationRecord) {
        CreationMode creationMode = instanceCreationRecord.hasStartInstructions() ? CreationMode.CREATION_AT_GIVEN_ELEMENT : CreationMode.CREATION_AT_DEFAULT_START_EVENT;
        ((Counter.Child)CREATED_PROCESS_INSTANCES.labels(new String[]{this.partitionIdLabel, creationMode.toString()})).inc();
    }

    private void elementInstanceEvent(String action, BpmnElementType elementType) {
        ((Counter.Child)ELEMENT_INSTANCE_EVENTS.labels(new String[]{action, elementType.name(), this.partitionIdLabel})).inc();
    }

    private void increaseRootProcessInstance(String action) {
        ((Counter.Child)EXECUTED_INSTANCES.labels(new String[]{ORGANIZATION_ID, "ROOT_PROCESS_INSTANCE", action, this.partitionIdLabel})).inc();
    }

    public void elementInstanceActivated(BpmnElementContext context) {
        BpmnElementType elementType = context.getBpmnElementType();
        this.elementInstanceEvent(ACTION_ACTIVATED, elementType);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(ACTION_ACTIVATED);
        }
    }

    public void elementInstanceCompleted(BpmnElementContext context) {
        BpmnElementType elementType = context.getBpmnElementType();
        this.elementInstanceEvent(ACTION_COMPLETED, elementType);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(ACTION_COMPLETED);
        }
    }

    public void elementInstanceTerminated(BpmnElementContext context) {
        BpmnElementType elementType = context.getBpmnElementType();
        this.elementInstanceEvent(ACTION_TERMINATED, elementType);
        if (this.isRootProcessInstance(elementType, context.getParentProcessInstanceKey())) {
            this.increaseRootProcessInstance(ACTION_TERMINATED);
        }
    }

    private boolean isProcessInstance(BpmnElementType elementType) {
        return BpmnElementType.PROCESS == elementType;
    }

    private boolean isRootProcessInstance(BpmnElementType elementType, long parentProcessInstanceKey) {
        return this.isProcessInstance(elementType) && parentProcessInstanceKey == -1L;
    }

    public void increaseSuccessfullyEvaluatedDmnElements(int amount) {
        this.increaseEvaluatedDmnElements(ACTION_EVALUATED_SUCCESSFULLY, amount);
    }

    public void increaseFailedEvaluatedDmnElements(int amount) {
        this.increaseEvaluatedDmnElements(ACTION_EVALUATED_FAILED, amount);
    }

    private void increaseEvaluatedDmnElements(String action, int amount) {
        ((Counter.Child)EVALUATED_DMN_ELEMENTS.labels(new String[]{ORGANIZATION_ID, action, this.partitionIdLabel})).inc((double)amount);
    }

    private static enum CreationMode {
        CREATION_AT_DEFAULT_START_EVENT,
        CREATION_AT_GIVEN_ELEMENT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

