/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceLifecycle;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCallActivity;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import java.util.Arrays;
import java.util.function.Function;
import org.agrona.DirectBuffer;

public final class BpmnStateTransitionBehavior {
    private static final String ALREADY_MIGRATED_ERROR_MSG = "The Processor for the element type %s is already migrated no need to call %s again this is already done in the BpmnStreamProcessor for you. Happy to help :) ";
    private static final String NO_PROCESS_FOUND_MESSAGE = "Expected to find a deployed process for process id '%s', but none found.";
    private final ProcessInstanceRecord childInstanceRecord = new ProcessInstanceRecord();
    private final ProcessInstanceRecord followUpInstanceRecord = new ProcessInstanceRecord();
    private final KeyGenerator keyGenerator;
    private final BpmnStateBehavior stateBehavior;
    private final Function<BpmnElementType, BpmnElementContainerProcessor<ExecutableFlowElement>> processorLookUp;
    private final ProcessEngineMetrics metrics;
    private final StateWriter stateWriter;
    private final TypedCommandWriter commandWriter;

    public BpmnStateTransitionBehavior(KeyGenerator keyGenerator, BpmnStateBehavior stateBehavior, ProcessEngineMetrics metrics, Function<BpmnElementType, BpmnElementContainerProcessor<ExecutableFlowElement>> processorLookUp, Writers writers) {
        this.keyGenerator = keyGenerator;
        this.stateBehavior = stateBehavior;
        this.metrics = metrics;
        this.processorLookUp = processorLookUp;
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
    }

    public BpmnElementContext transitionToActivating(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        if (elementInstance != null) {
            this.verifyIncidentResolving(context, "#transitionToActivating");
            return context.copy(context.getElementInstanceKey(), context.getRecordValue(), ProcessInstanceIntent.ELEMENT_ACTIVATING);
        }
        BpmnElementContext transitionContext = context;
        if (context.getElementInstanceKey() == -1L) {
            long newElementInstanceKey = this.keyGenerator.nextKey();
            transitionContext = context.copy(newElementInstanceKey, context.getRecordValue(), context.getIntent());
        }
        return this.transitionTo(transitionContext, ProcessInstanceIntent.ELEMENT_ACTIVATING);
    }

    public BpmnElementContext transitionToActivated(BpmnElementContext context) {
        BpmnElementContext transitionedContext = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_ACTIVATED);
        this.metrics.elementInstanceActivated(context);
        return transitionedContext;
    }

    public BpmnElementContext transitionToCompleting(BpmnElementContext context) {
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        if (elementInstance.getState() == ProcessInstanceIntent.ELEMENT_COMPLETING) {
            this.verifyIncidentResolving(context, "#transitionToCompleting");
            return context.copy(context.getElementInstanceKey(), context.getRecordValue(), ProcessInstanceIntent.ELEMENT_COMPLETING);
        }
        return this.transitionTo(context, ProcessInstanceIntent.ELEMENT_COMPLETING);
    }

    private void verifyIncidentResolving(BpmnElementContext context, String methodName) {
        IllegalStateException illegalStateException = new IllegalStateException(String.format(ALREADY_MIGRATED_ERROR_MSG, context.getBpmnElementType(), methodName));
        if (Arrays.stream(illegalStateException.getStackTrace()).noneMatch(ele -> ele.getMethodName().equals("attemptToContinueProcessProcessing"))) {
            throw illegalStateException;
        }
    }

    public <T extends ExecutableFlowNode> Either<Failure, BpmnElementContext> transitionToCompleted(T element, BpmnElementContext context) {
        Either<Failure, ?> satisfiesCompletionConditionOrFailure;
        boolean endOfExecutionPath = context.getBpmnElementType() == BpmnElementType.PROCESS ? false : element.getOutgoing().isEmpty();
        if (endOfExecutionPath) {
            satisfiesCompletionConditionOrFailure = this.beforeExecutionPathCompleted(element, context);
            if (satisfiesCompletionConditionOrFailure.isLeft()) {
                return satisfiesCompletionConditionOrFailure.map(ok -> context);
            }
        } else {
            satisfiesCompletionConditionOrFailure = Either.right(null);
        }
        BpmnElementContext completed = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_COMPLETED);
        this.metrics.elementInstanceCompleted(context);
        if (endOfExecutionPath) {
            this.afterExecutionPathCompleted(element, completed, (Boolean)satisfiesCompletionConditionOrFailure.get());
        }
        return Either.right((Object)completed);
    }

    public BpmnElementContext transitionToTerminating(BpmnElementContext context) {
        if (context.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING) {
            throw new IllegalStateException(String.format(ALREADY_MIGRATED_ERROR_MSG, context.getBpmnElementType(), "#transitionToTerminating"));
        }
        return this.transitionTo(context, ProcessInstanceIntent.ELEMENT_TERMINATING);
    }

    public BpmnElementContext transitionToTerminated(BpmnElementContext context) {
        BpmnElementContext transitionedContext = this.transitionTo(context, ProcessInstanceIntent.ELEMENT_TERMINATED);
        this.metrics.elementInstanceTerminated(context);
        return transitionedContext;
    }

    private BpmnElementContext transitionTo(BpmnElementContext context, ProcessInstanceIntent transition) {
        long key = context.getElementInstanceKey();
        ProcessInstanceRecord value = context.getRecordValue();
        this.stateWriter.appendFollowUpEvent(key, (Intent)transition, (RecordValue)value);
        return context.copy(key, value, transition);
    }

    private void verifyTransition(BpmnElementContext context, ProcessInstanceIntent transition) {
        if (!ProcessInstanceLifecycle.canTransition(context.getIntent(), transition)) {
            throw new BpmnProcessingException(context, String.format("Expected to take transition to '%s' but element instance is in state '%s'.", transition, context.getIntent()));
        }
    }

    public void takeSequenceFlow(BpmnElementContext context, ExecutableSequenceFlow sequenceFlow) {
        this.verifyTransition(context, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN);
        ExecutableFlowNode target = sequenceFlow.getTarget();
        this.followUpInstanceRecord.wrap(context.getRecordValue());
        this.followUpInstanceRecord.setElementId(sequenceFlow.getId()).setBpmnElementType(sequenceFlow.getElementType());
        long sequenceFlowKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(sequenceFlowKey, (Intent)ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, (RecordValue)this.followUpInstanceRecord);
        BpmnElementContext sequenceFlowTaken = context.copy(sequenceFlowKey, this.followUpInstanceRecord, ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN);
        this.activateElementInstanceInFlowScope(sequenceFlowTaken, target);
    }

    public void completeElement(BpmnElementContext context) {
        this.commandWriter.appendFollowUpCommand(context.getElementInstanceKey(), (Intent)ProcessInstanceIntent.COMPLETE_ELEMENT, (RecordValue)context.getRecordValue());
    }

    public void terminateElement(BpmnElementContext context) {
        this.commandWriter.appendFollowUpCommand(context.getElementInstanceKey(), (Intent)ProcessInstanceIntent.TERMINATE_ELEMENT, (RecordValue)context.getRecordValue());
    }

    public void activateChildInstance(BpmnElementContext context, ExecutableFlowElement childElement) {
        this.childInstanceRecord.wrap(context.getRecordValue());
        this.childInstanceRecord.setFlowScopeKey(context.getElementInstanceKey()).setElementId(childElement.getId()).setBpmnElementType(childElement.getElementType());
        this.commandWriter.appendNewCommand((Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)this.childInstanceRecord);
    }

    public long activateChildInstanceWithKey(BpmnElementContext context, ExecutableFlowElement childElement) {
        this.childInstanceRecord.wrap(context.getRecordValue());
        this.childInstanceRecord.setFlowScopeKey(context.getElementInstanceKey()).setElementId(childElement.getId()).setBpmnElementType(childElement.getElementType());
        long childInstanceKey = this.keyGenerator.nextKey();
        this.commandWriter.appendFollowUpCommand(childInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)this.childInstanceRecord);
        return childInstanceKey;
    }

    public void activateElementInstanceInFlowScope(BpmnElementContext context, ExecutableFlowElement element) {
        this.followUpInstanceRecord.wrap(context.getRecordValue());
        this.followUpInstanceRecord.setFlowScopeKey(context.getFlowScopeKey()).setElementId(element.getId()).setBpmnElementType(element.getElementType());
        long elementInstanceKey = this.keyGenerator.nextKey();
        this.commandWriter.appendFollowUpCommand(elementInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)this.followUpInstanceRecord);
    }

    public boolean terminateChildInstances(BpmnElementContext context) {
        this.stateBehavior.getChildInstances(context).stream().filter(child -> ProcessInstanceLifecycle.canTerminate(child.getIntent())).forEach(childInstanceContext -> this.commandWriter.appendFollowUpCommand(childInstanceContext.getElementInstanceKey(), (Intent)ProcessInstanceIntent.TERMINATE_ELEMENT, (RecordValue)childInstanceContext.getRecordValue()));
        ElementInstance elementInstance = this.stateBehavior.getElementInstance(context);
        int activeChildInstances = elementInstance.getNumberOfActiveElementInstances();
        return activeChildInstances == 0;
    }

    public <T extends ExecutableFlowNode> void takeOutgoingSequenceFlows(T element, BpmnElementContext context) {
        element.getOutgoing().forEach(sequenceFlow -> this.takeSequenceFlow(context, (ExecutableSequenceFlow)sequenceFlow));
    }

    public Either<Failure, ?> beforeExecutionPathCompleted(ExecutableFlowElement element, BpmnElementContext childContext) {
        return this.invokeElementContainerIfPresent(element, childContext, (containerProcessor, containerScope, containerContext) -> containerProcessor.beforeExecutionPathCompleted(containerScope, containerContext, childContext));
    }

    public void onCalledProcessCompleted(BpmnElementContext childContext, BpmnElementContext parentInstanceContext) {
        ExecutableCallActivity containerScope = this.getParentProcessScope(parentInstanceContext, childContext);
        BpmnElementContainerProcessor<ExecutableFlowElement> containerProcessor = this.processorLookUp.apply(containerScope.getElementType());
        Either<Failure, ?> satisfiesCompletionConditionOrFailure = containerProcessor.beforeExecutionPathCompleted(containerScope, parentInstanceContext, childContext);
        containerProcessor.afterExecutionPathCompleted(containerScope, parentInstanceContext, childContext, (Boolean)satisfiesCompletionConditionOrFailure.get());
    }

    public void onCalledProcessTerminated(BpmnElementContext childContext, BpmnElementContext parentInstanceContext) {
        ExecutableCallActivity containerScope = this.getParentProcessScope(parentInstanceContext, childContext);
        BpmnElementContainerProcessor<ExecutableFlowElement> containerProcessor = this.processorLookUp.apply(containerScope.getElementType());
        containerProcessor.onChildTerminated(containerScope, parentInstanceContext, childContext);
    }

    public void afterExecutionPathCompleted(ExecutableFlowElement element, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        this.invokeElementContainerIfPresent(element, childContext, (containerProcessor, containerScope, containerContext) -> {
            containerProcessor.afterExecutionPathCompleted(containerScope, containerContext, childContext, satisfiesCompletionCondition);
            return Either.right(null);
        });
    }

    public void onElementTerminated(ExecutableFlowElement element, BpmnElementContext childContext) {
        this.invokeElementContainerIfPresent(element, childContext, (containerProcessor, containerScope, containerContext) -> {
            containerProcessor.onChildTerminated(containerScope, containerContext, childContext);
            return Either.right(null);
        });
    }

    public Either<Failure, ?> onElementActivating(ExecutableFlowElement element, BpmnElementContext childContext) {
        return this.invokeElementContainerIfPresent(element, childContext, (containerProcessor, containerScope, containerContext) -> containerProcessor.onChildActivating(containerScope, containerContext, childContext));
    }

    private Either<Failure, ?> invokeElementContainerIfPresent(ExecutableFlowElement childElement, BpmnElementContext childContext, ElementContainerProcessorFunction containerFunction) {
        ExecutableFlowElement containerScope;
        BpmnElementContext containerContext;
        ExecutableFlowElement flowScope = childElement.getFlowScope();
        if (flowScope != null) {
            containerContext = this.stateBehavior.getFlowScopeContext(childContext);
            containerScope = flowScope;
        } else if (childContext.getParentElementInstanceKey() > 0L) {
            containerContext = this.stateBehavior.getParentElementInstanceContext(childContext);
            containerScope = this.getParentProcessScope(containerContext, childContext);
        } else {
            return Either.right(null);
        }
        BpmnElementContainerProcessor<ExecutableFlowElement> containerProcessor = this.processorLookUp.apply(containerScope.getElementType());
        return containerFunction.apply(containerProcessor, containerScope, containerContext);
    }

    private ExecutableCallActivity getParentProcessScope(BpmnElementContext callActivityContext, BpmnElementContext childContext) {
        long processDefinitionKey = callActivityContext.getProcessDefinitionKey();
        DirectBuffer elementId = callActivityContext.getElementId();
        return this.stateBehavior.getProcess(processDefinitionKey).map(DeployedProcess::getProcess).map(process -> process.getElementById(elementId, BpmnElementType.CALL_ACTIVITY, ExecutableCallActivity.class)).orElseThrow(() -> new BpmnProcessingException(childContext, String.format(NO_PROCESS_FOUND_MESSAGE, processDefinitionKey)));
    }

    public long createChildProcessInstance(DeployedProcess process, BpmnElementContext context) {
        long processInstanceKey = this.keyGenerator.nextKey();
        this.childInstanceRecord.reset();
        this.childInstanceRecord.setBpmnProcessId(process.getBpmnProcessId()).setVersion(process.getVersion()).setProcessDefinitionKey(process.getKey()).setProcessInstanceKey(processInstanceKey).setParentProcessInstanceKey(context.getProcessInstanceKey()).setParentElementInstanceKey(context.getElementInstanceKey()).setElementId(process.getProcess().getId()).setBpmnElementType(process.getProcess().getElementType());
        this.commandWriter.appendFollowUpCommand(processInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)this.childInstanceRecord);
        return processInstanceKey;
    }

    public <T extends ExecutableFlowElement> void terminateChildProcessInstance(BpmnElementContainerProcessor<T> containerProcessor, T element, BpmnElementContext context) {
        this.stateBehavior.getCalledChildInstance(context).ifPresentOrElse(child -> this.terminateElement(context.copy(child.getKey(), child.getValue(), child.getState())), () -> containerProcessor.onChildTerminated(element, context, null));
    }

    @FunctionalInterface
    private static interface ElementContainerProcessorFunction {
        public Either<Failure, ?> apply(BpmnElementContainerProcessor<ExecutableFlowElement> var1, ExecutableFlowElement var2, BpmnElementContext var3);
    }
}

