/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableExclusiveGateway;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSequenceFlow;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Optional;
import org.agrona.DirectBuffer;

public final class ExclusiveGatewayProcessor
implements BpmnElementProcessor<ExecutableExclusiveGateway> {
    private static final String NO_OUTGOING_FLOW_CHOSEN_ERROR = "Expected at least one condition to evaluate to true, or to have a default flow";
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final ExpressionProcessor expressionBehavior;

    public ExclusiveGatewayProcessor(BpmnBehaviors behaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.expressionBehavior = behaviors.expressionBehavior();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
    }

    @Override
    public Class<ExecutableExclusiveGateway> getType() {
        return ExecutableExclusiveGateway.class;
    }

    @Override
    public void onActivate(ExecutableExclusiveGateway element, BpmnElementContext activating) {
        this.findSequenceFlowToTake(element, activating).ifRightOrLeft(optFlow -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(activating);
            BpmnElementContext completing = this.stateTransitionBehavior.transitionToCompleting(activated);
            this.stateTransitionBehavior.transitionToCompleted(element, completing).ifRightOrLeft(completed -> optFlow.ifPresent(flow -> this.stateTransitionBehavior.takeSequenceFlow((BpmnElementContext)completed, (ExecutableSequenceFlow)flow)), failure -> this.incidentBehavior.createIncident((Failure)failure, completing));
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, activating));
    }

    @Override
    public void onComplete(ExecutableExclusiveGateway element, BpmnElementContext context) {
        throw new UnsupportedOperationException(String.format("Expected to explicitly process complete, but gateway %s has no wait state", BufferUtil.bufferAsString((DirectBuffer)context.getElementId())));
    }

    @Override
    public void onTerminate(ExecutableExclusiveGateway element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }

    private Either<Failure, Optional<ExecutableSequenceFlow>> findSequenceFlowToTake(ExecutableExclusiveGateway element, BpmnElementContext context) {
        if (element.getOutgoing().isEmpty()) {
            return Either.right(Optional.empty());
        }
        if (element.getOutgoing().size() == 1 && element.getOutgoing().get(0).getCondition() == null) {
            return Either.right(Optional.of(element.getOutgoing().get(0)));
        }
        for (ExecutableSequenceFlow sequenceFlow : element.getOutgoingWithCondition()) {
            Expression condition = sequenceFlow.getCondition();
            Either<Failure, Boolean> isFulfilledOrFailure = this.expressionBehavior.evaluateBooleanExpression(condition, context.getElementInstanceKey());
            if (isFulfilledOrFailure.isLeft()) {
                return Either.left((Object)((Failure)isFulfilledOrFailure.getLeft()));
            }
            if (!((Boolean)isFulfilledOrFailure.get()).booleanValue()) continue;
            return Either.right(Optional.of(sequenceFlow));
        }
        if (element.getDefaultFlow() != null) {
            return Either.right(Optional.of(element.getDefaultFlow()));
        }
        return Either.left((Object)new Failure(NO_OUTGOING_FLOW_CHOSEN_ERROR, ErrorType.CONDITION_ERROR, context.getElementInstanceKey()));
    }
}

