/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.EventSubscriptionException;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.common.MultipleFlowScopeInstancesFoundException;
import io.camunda.zeebe.engine.processing.deployment.model.element.AbstractFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import org.agrona.DirectBuffer;

public final class ElementActivationBehavior {
    private final SideEffectQueue sideEffectQueue = new SideEffectQueue();
    private final KeyGenerator keyGenerator;
    private final TypedCommandWriter commandWriter;
    private final StateWriter stateWriter;
    private final CatchEventBehavior catchEventBehavior;
    private final ElementInstanceState elementInstanceState;

    public ElementActivationBehavior(KeyGenerator keyGenerator, Writers writers, CatchEventBehavior catchEventBehavior, ElementInstanceState elementInstanceState) {
        this.keyGenerator = keyGenerator;
        this.catchEventBehavior = catchEventBehavior;
        this.elementInstanceState = elementInstanceState;
        this.commandWriter = writers.command();
        this.stateWriter = writers.state();
    }

    public ActivatedElementKeys activateElement(ProcessInstanceRecord processInstanceRecord, AbstractFlowElement elementToActivate) {
        return this.activateElement(processInstanceRecord, elementToActivate, (empty, function) -> {});
    }

    public ActivatedElementKeys activateElement(ProcessInstanceRecord processInstanceRecord, AbstractFlowElement elementToActivate, BiConsumer<DirectBuffer, Long> createVariablesCallback) {
        ActivatedElementKeys activatedElementKeys = new ActivatedElementKeys();
        Deque<ExecutableFlowElement> flowScopes = this.collectFlowScopesOfElement(elementToActivate);
        long flowScopeKey = this.activateFlowScopes(processInstanceRecord, processInstanceRecord.getProcessInstanceKey(), flowScopes, createVariablesCallback, activatedElementKeys);
        long elementInstanceKey = this.activateElementByCommand(processInstanceRecord, elementToActivate, flowScopeKey);
        createVariablesCallback.accept(elementToActivate.getId(), elementInstanceKey);
        activatedElementKeys.setElementInstanceKey(elementInstanceKey);
        this.sideEffectQueue.flush();
        return activatedElementKeys;
    }

    private Deque<ExecutableFlowElement> collectFlowScopesOfElement(ExecutableFlowElement element) {
        ArrayDeque<ExecutableFlowElement> flowScopes = new ArrayDeque<ExecutableFlowElement>();
        for (ExecutableFlowElement currentElement = element.getFlowScope(); currentElement != null; currentElement = currentElement.getFlowScope()) {
            flowScopes.addFirst(currentElement);
        }
        return flowScopes;
    }

    private long activateFlowScopes(ProcessInstanceRecord processInstanceRecord, long flowScopeKey, Deque<ExecutableFlowElement> flowScopes, BiConsumer<DirectBuffer, Long> createVariablesCallback, ActivatedElementKeys activatedElementKeys) {
        if (flowScopes.isEmpty()) {
            return flowScopeKey;
        }
        ExecutableFlowElement flowScope = flowScopes.poll();
        List<ElementInstance> elementInstancesOfScope = this.findElementInstances(flowScope, flowScopeKey);
        if (elementInstancesOfScope.isEmpty()) {
            long elementInstanceKey = this.activateFlowScope(processInstanceRecord, flowScopeKey, flowScope, createVariablesCallback);
            activatedElementKeys.addFlowScopeKey(elementInstanceKey);
            return this.activateFlowScopes(processInstanceRecord, elementInstanceKey, flowScopes, createVariablesCallback, activatedElementKeys);
        }
        if (elementInstancesOfScope.size() == 1) {
            ElementInstance elementInstance = elementInstancesOfScope.get(0);
            createVariablesCallback.accept(flowScope.getId(), elementInstance.getKey());
            activatedElementKeys.addFlowScopeKey(elementInstance.getKey());
            return this.activateFlowScopes(processInstanceRecord, elementInstance.getKey(), flowScopes, createVariablesCallback, activatedElementKeys);
        }
        String flowScopeId = BufferUtil.bufferAsString((DirectBuffer)flowScope.getId());
        throw new MultipleFlowScopeInstancesFoundException(flowScopeId, processInstanceRecord.getBpmnProcessId());
    }

    private List<ElementInstance> findElementInstances(ExecutableFlowElement element, long flowScopeKey) {
        if (ElementActivationBehavior.isProcess(element)) {
            return Optional.ofNullable(this.elementInstanceState.getInstance(flowScopeKey)).map(List::of).orElse(Collections.emptyList());
        }
        return this.elementInstanceState.getChildren(flowScopeKey).stream().filter(instance -> instance.getValue().getElementIdBuffer().equals(element.getId())).toList();
    }

    private static boolean isProcess(ExecutableFlowElement element) {
        return element.getElementType() == BpmnElementType.PROCESS;
    }

    private long activateFlowScope(ProcessInstanceRecord processInstanceRecord, long flowScopeKey, ExecutableFlowElement flowScope, BiConsumer<DirectBuffer, Long> createVariablesCallback) {
        long elementInstanceFlowScopeKey;
        long elementInstanceKey;
        if (ElementActivationBehavior.isProcess(flowScope)) {
            elementInstanceKey = processInstanceRecord.getProcessInstanceKey();
            elementInstanceFlowScopeKey = -1L;
        } else {
            elementInstanceKey = this.keyGenerator.nextKey();
            elementInstanceFlowScopeKey = flowScopeKey;
        }
        this.activateFlowScopeByEvents(processInstanceRecord, flowScope, elementInstanceKey, elementInstanceFlowScopeKey, createVariablesCallback);
        return elementInstanceKey;
    }

    private void activateFlowScopeByEvents(ProcessInstanceRecord processInstanceRecord, ExecutableFlowElement element, long elementInstanceKey, long flowScopeKey, BiConsumer<DirectBuffer, Long> createVariablesCallback) {
        ProcessInstanceRecord elementRecord = this.createElementRecord(processInstanceRecord, element, flowScopeKey);
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING, (RecordValue)elementRecord);
        createVariablesCallback.accept(element.getId(), elementInstanceKey);
        this.stateWriter.appendFollowUpEvent(elementInstanceKey, (Intent)ProcessInstanceIntent.ELEMENT_ACTIVATED, (RecordValue)elementRecord);
        this.createEventSubscriptions(element, elementRecord, elementInstanceKey);
    }

    private long activateElementByCommand(ProcessInstanceRecord processInstanceRecord, AbstractFlowElement elementToActivate, long flowScopeKey) {
        long elementInstanceKey = this.keyGenerator.nextKey();
        ProcessInstanceRecord elementRecord = this.createElementRecord(processInstanceRecord, elementToActivate, flowScopeKey);
        this.commandWriter.appendFollowUpCommand(elementInstanceKey, (Intent)ProcessInstanceIntent.ACTIVATE_ELEMENT, (RecordValue)elementRecord);
        return elementInstanceKey;
    }

    private ProcessInstanceRecord createElementRecord(ProcessInstanceRecord processInstanceRecord, ExecutableFlowElement elementToActivate, long flowScopeKey) {
        ProcessInstanceRecord elementInstanceRecord = new ProcessInstanceRecord();
        elementInstanceRecord.wrap(processInstanceRecord);
        elementInstanceRecord.setElementId(elementToActivate.getId()).setBpmnElementType(elementToActivate.getElementType()).setFlowScopeKey(flowScopeKey).setParentProcessInstanceKey(-1L).setParentElementInstanceKey(-1L);
        return elementInstanceRecord;
    }

    private void createEventSubscriptions(ExecutableFlowElement element, ProcessInstanceRecord elementRecord, long elementInstanceKey) {
        if (element instanceof ExecutableCatchEventSupplier) {
            ExecutableCatchEventSupplier catchEventSupplier = (ExecutableCatchEventSupplier)element;
            BpmnElementContextImpl bpmnElementContext = new BpmnElementContextImpl();
            bpmnElementContext.init(elementInstanceKey, elementRecord, ProcessInstanceIntent.ELEMENT_ACTIVATED);
            Either<Failure, Void> subscribedOrFailure = this.catchEventBehavior.subscribeToEvents(bpmnElementContext, catchEventSupplier, this.sideEffectQueue);
            if (subscribedOrFailure.isLeft()) {
                String message = "Expected to subscribe to catch event(s) of '%s' but %s".formatted(BufferUtil.bufferAsString((DirectBuffer)element.getId()), ((Failure)subscribedOrFailure.getLeft()).getMessage());
                throw new EventSubscriptionException(message);
            }
        }
    }

    public static class ActivatedElementKeys {
        private final Set<Long> flowScopeKeys = new HashSet<Long>();
        private Long elementInstanceKey;

        private void addFlowScopeKey(Long flowScopeKey) {
            this.flowScopeKeys.add(flowScopeKey);
        }

        public Long getElementInstanceKey() {
            return this.elementInstanceKey;
        }

        private void setElementInstanceKey(Long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
        }

        public Set<Long> getFlowScopeKeys() {
            return this.flowScopeKeys;
        }
    }
}

