/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.distribute;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.DeploymentState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentDistributionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;

public class CompleteDeploymentDistributionProcessor
implements TypedRecordProcessor<DeploymentDistributionRecord> {
    private static final String REJECT_MSG_DEPLOYMENT_DISTRIBUTION_COMPLETED = "Expected to find pending deployment with key %d, but deployment distribution already completed.";
    private final DeploymentRecord emptyDeploymentRecord = new DeploymentRecord();
    private final StateWriter stateWriter;
    private final DeploymentState deploymentState;
    private final TypedRejectionWriter rejectionWriter;

    public CompleteDeploymentDistributionProcessor(DeploymentState deploymentState, Writers writers) {
        this.stateWriter = writers.state();
        this.deploymentState = deploymentState;
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<DeploymentDistributionRecord> record) {
        int partitionId;
        long deploymentKey = record.getKey();
        if (!this.deploymentState.hasPendingDeploymentDistribution(deploymentKey, partitionId = record.getValue().getPartitionId())) {
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(REJECT_MSG_DEPLOYMENT_DISTRIBUTION_COMPLETED, deploymentKey));
            return;
        }
        this.stateWriter.appendFollowUpEvent(deploymentKey, (Intent)DeploymentDistributionIntent.COMPLETED, (RecordValue)record.getValue());
        if (!this.deploymentState.hasPendingDeploymentDistribution(deploymentKey)) {
            this.stateWriter.appendFollowUpEvent(deploymentKey, (Intent)DeploymentIntent.FULLY_DISTRIBUTED, (RecordValue)this.emptyDeploymentRecord);
        }
    }
}

