/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.api.InterPartitionCommandSender;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;

public class SubscriptionCommandSender {
    private final InterPartitionCommandSender interPartitionCommandSender;
    private final int senderPartition;

    public SubscriptionCommandSender(int senderPartition, InterPartitionCommandSender interPartitionCommandSender) {
        this.senderPartition = senderPartition;
        this.interPartitionCommandSender = interPartitionCommandSender;
    }

    public boolean openMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate) {
        this.interPartitionCommandSender.sendCommand(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CREATE, (BufferWriter)new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageKey(-1L).setMessageName(messageName).setCorrelationKey(correlationKey).setInterrupting(closeOnCorrelate));
        return true;
    }

    public boolean openProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer messageName, boolean closeOnCorrelate) {
        this.interPartitionCommandSender.sendCommand(Protocol.decodePartitionId((long)processInstanceKey), ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CREATE, (BufferWriter)new ProcessMessageSubscriptionRecord().setSubscriptionPartitionId(this.senderPartition).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setMessageKey(-1L).setMessageName(messageName).setInterrupting(closeOnCorrelate));
        return true;
    }

    public boolean correlateProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, long messageKey, DirectBuffer variables, DirectBuffer correlationKey) {
        this.interPartitionCommandSender.sendCommand(Protocol.decodePartitionId((long)processInstanceKey), ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CORRELATE, (BufferWriter)new ProcessMessageSubscriptionRecord().setSubscriptionPartitionId(this.senderPartition).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageKey(messageKey).setMessageName(messageName).setVariables(variables).setCorrelationKey(correlationKey));
        return true;
    }

    public boolean correlateMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName) {
        this.interPartitionCommandSender.sendCommand(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, (BufferWriter)new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageKey(-1L).setMessageName(messageName));
        return true;
    }

    public boolean closeMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        this.interPartitionCommandSender.sendCommand(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.DELETE, (BufferWriter)new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setMessageKey(-1L).setMessageName(messageName));
        return true;
    }

    public boolean closeProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        this.interPartitionCommandSender.sendCommand(Protocol.decodePartitionId((long)processInstanceKey), ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.DELETE, (BufferWriter)new ProcessMessageSubscriptionRecord().setSubscriptionPartitionId(this.senderPartition).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setMessageKey(-1L).setMessageName(messageName));
        return true;
    }

    public boolean rejectCorrelateMessageSubscription(long processInstanceKey, DirectBuffer bpmnProcessId, long messageKey, DirectBuffer messageName, DirectBuffer correlationKey) {
        this.interPartitionCommandSender.sendCommand(Protocol.decodePartitionId((long)processInstanceKey), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.REJECT, (BufferWriter)new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(-1L).setBpmnProcessId(bpmnProcessId).setMessageName(messageName).setCorrelationKey(correlationKey).setMessageKey(messageKey).setInterrupting(false));
        return true;
    }
}

