/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowNode;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import java.util.Collections;
import java.util.Objects;

final class ProcessInstanceModifiedEventApplier
implements TypedEventApplier<ProcessInstanceModificationIntent, ProcessInstanceModificationRecord> {
    private final MutableElementInstanceState elementInstanceState;
    private final MutableProcessState processState;

    public ProcessInstanceModifiedEventApplier(MutableElementInstanceState elementInstanceState, MutableProcessState processState) {
        this.elementInstanceState = elementInstanceState;
        this.processState = processState;
    }

    @Override
    public void applyState(long key, ProcessInstanceModificationRecord value) {
        if (value.hasActivateInstructions()) {
            this.clearInterruptedState(value);
            this.incrementNumberOfTakenSequenceFlows(value);
        }
    }

    private void clearInterruptedState(ProcessInstanceModificationRecord value) {
        value.getAncestorScopeKeys().stream().map(this.elementInstanceState::getInstance).filter(Objects::nonNull).filter(ElementInstance::isInterrupted).forEach(instance -> this.elementInstanceState.updateInstance(instance.getKey(), ElementInstance::clearInterruptedState));
    }

    private void incrementNumberOfTakenSequenceFlows(ProcessInstanceModificationRecord value) {
        ElementInstance processInstance = this.elementInstanceState.getInstance(value.getProcessInstanceKey());
        ExecutableProcess process = this.processState.getProcessByKey(processInstance.getValue().getProcessDefinitionKey()).getProcess();
        value.getActivateInstructions().forEach(instruction -> {
            ExecutableFlowNode element = process.getElementById(instruction.getElementId(), ExecutableFlowNode.class);
            if (!element.getElementType().equals((Object)BpmnElementType.PARALLEL_GATEWAY)) {
                return;
            }
            Long parentFlowScopeKey = (Long)Collections.max(instruction.getAncestorScopeKeys());
            element.getIncoming().forEach(incoming -> this.elementInstanceState.incrementNumberOfTakenSequenceFlows(parentFlowScopeKey, element.getId(), incoming.getId()));
        });
    }
}

