/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.ProcessEventProcessors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviorsImpl;
import io.camunda.zeebe.engine.processing.deployment.DeploymentCreateProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.CompleteDeploymentDistributionProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributeProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentRedistributor;
import io.camunda.zeebe.engine.processing.incident.IncidentEventProcessors;
import io.camunda.zeebe.engine.processing.job.JobEventProcessors;
import io.camunda.zeebe.engine.processing.message.MessageEventProcessors;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.migration.DbMigrationController;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.FeatureFlags;
import java.util.function.Consumer;

public final class EngineProcessors {
    private EngineProcessors() {
    }

    public static TypedRecordProcessors createEngineProcessors(TypedRecordProcessorContext typedRecordProcessorContext, int partitionsCount, SubscriptionCommandSender subscriptionCommandSender, DeploymentDistributionCommandSender deploymentDistributionCommandSender, Consumer<String> onJobsAvailableCallback, FeatureFlags featureFlags) {
        MutableZeebeState zeebeState = typedRecordProcessorContext.getZeebeState();
        Writers writers = typedRecordProcessorContext.getWriters();
        TypedRecordProcessors typedRecordProcessors = TypedRecordProcessors.processors(zeebeState.getKeyGenerator(), writers);
        typedRecordProcessors.withListener(new DbMigrationController(zeebeState));
        typedRecordProcessors.withListener(zeebeState);
        int partitionId = typedRecordProcessorContext.getPartitionId();
        DueDateTimerChecker timerChecker = new DueDateTimerChecker(zeebeState.getTimerState(), featureFlags);
        JobMetrics jobMetrics = new JobMetrics(partitionId);
        ProcessEngineMetrics processEngineMetrics = new ProcessEngineMetrics(zeebeState.getPartitionId());
        BpmnBehaviorsImpl bpmnBehaviors = EngineProcessors.createBehaviors(zeebeState, writers, subscriptionCommandSender, partitionsCount, timerChecker, jobMetrics, processEngineMetrics);
        EngineProcessors.addDeploymentRelatedProcessorAndServices(bpmnBehaviors, zeebeState, typedRecordProcessors, writers, partitionsCount, deploymentDistributionCommandSender, zeebeState.getKeyGenerator());
        EngineProcessors.addMessageProcessors(bpmnBehaviors, subscriptionCommandSender, zeebeState, typedRecordProcessors, writers);
        TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor = EngineProcessors.addProcessProcessors(zeebeState, bpmnBehaviors, typedRecordProcessors, subscriptionCommandSender, writers, timerChecker);
        JobEventProcessors.addJobProcessors(typedRecordProcessors, zeebeState, onJobsAvailableCallback, bpmnBehaviors, writers, jobMetrics);
        EngineProcessors.addIncidentProcessors(zeebeState, bpmnStreamProcessor, typedRecordProcessors, writers);
        return typedRecordProcessors;
    }

    private static BpmnBehaviorsImpl createBehaviors(MutableZeebeState zeebeState, Writers writers, SubscriptionCommandSender subscriptionCommandSender, int partitionsCount, DueDateTimerChecker timerChecker, JobMetrics jobMetrics, ProcessEngineMetrics processEngineMetrics) {
        return new BpmnBehaviorsImpl(zeebeState, writers, jobMetrics, processEngineMetrics, subscriptionCommandSender, partitionsCount, timerChecker);
    }

    private static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableZeebeState zeebeState, BpmnBehaviorsImpl bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, Writers writers, DueDateTimerChecker timerChecker) {
        return ProcessEventProcessors.addProcessProcessors(zeebeState, bpmnBehaviors, typedRecordProcessors, subscriptionCommandSender, timerChecker, writers);
    }

    private static void addDeploymentRelatedProcessorAndServices(BpmnBehaviorsImpl bpmnBehaviors, ZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, Writers writers, int partitionsCount, DeploymentDistributionCommandSender deploymentDistributionCommandSender, KeyGenerator keyGenerator) {
        DeploymentCreateProcessor processor = new DeploymentCreateProcessor(zeebeState, bpmnBehaviors, partitionsCount, writers, deploymentDistributionCommandSender, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE, processor);
        DeploymentRedistributor deploymentRedistributor = new DeploymentRedistributor(deploymentDistributionCommandSender, zeebeState.getDeploymentState());
        typedRecordProcessors.withListener(deploymentRedistributor);
        DeploymentDistributeProcessor deploymentDistributeProcessor = new DeploymentDistributeProcessor(zeebeState.getProcessState(), zeebeState.getMessageStartEventSubscriptionState(), deploymentDistributionCommandSender, writers, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.DISTRIBUTE, deploymentDistributeProcessor);
        CompleteDeploymentDistributionProcessor completeDeploymentDistributionProcessor = new CompleteDeploymentDistributionProcessor(zeebeState.getDeploymentState(), writers);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT_DISTRIBUTION, (Intent)DeploymentDistributionIntent.COMPLETE, completeDeploymentDistributionProcessor);
    }

    private static void addIncidentProcessors(ZeebeState zeebeState, TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor, TypedRecordProcessors typedRecordProcessors, Writers writers) {
        IncidentEventProcessors.addProcessors(typedRecordProcessors, zeebeState, bpmnStreamProcessor, writers);
    }

    private static void addMessageProcessors(BpmnBehaviorsImpl bpmnBehaviors, SubscriptionCommandSender subscriptionCommandSender, MutableZeebeState zeebeState, TypedRecordProcessors typedRecordProcessors, Writers writers) {
        MessageEventProcessors.addMessageProcessors(bpmnBehaviors, typedRecordProcessors, zeebeState, subscriptionCommandSender, writers);
    }
}

