/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.BpmnStreamProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.message.PendingProcessMessageSubscriptionChecker;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionCorrelateProcessor;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionCreateProcessor;
import io.camunda.zeebe.engine.processing.message.ProcessMessageSubscriptionDeleteProcessor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.processinstance.CreateProcessInstanceProcessor;
import io.camunda.zeebe.engine.processing.processinstance.CreateProcessInstanceWithResultProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceCommandProcessor;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceModificationProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.CancelTimerProcessor;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.processing.timer.TriggerTimerProcessor;
import io.camunda.zeebe.engine.processing.variable.UpdateVariableDocumentProcessor;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import java.util.Arrays;

public final class ProcessEventProcessors {
    public static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableZeebeState zeebeState, BpmnBehaviors bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, DueDateTimerChecker timerChecker, Writers writers) {
        MutableProcessMessageSubscriptionState subscriptionState = zeebeState.getProcessMessageSubscriptionState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        ProcessEngineMetrics processEngineMetrics = new ProcessEngineMetrics(zeebeState.getPartitionId());
        ProcessEventProcessors.addProcessInstanceCommandProcessor(writers, typedRecordProcessors, zeebeState.getElementInstanceState());
        BpmnStreamProcessor bpmnStreamProcessor = new BpmnStreamProcessor(bpmnBehaviors, zeebeState, writers, processEngineMetrics);
        ProcessEventProcessors.addBpmnStepProcessor(typedRecordProcessors, bpmnStreamProcessor);
        ProcessEventProcessors.addMessageStreamProcessors(typedRecordProcessors, subscriptionState, subscriptionCommandSender, bpmnBehaviors, zeebeState, writers);
        ProcessEventProcessors.addTimerStreamProcessors(typedRecordProcessors, timerChecker, zeebeState, bpmnBehaviors, writers);
        ProcessEventProcessors.addVariableDocumentStreamProcessors(typedRecordProcessors, bpmnBehaviors, zeebeState.getElementInstanceState(), keyGenerator, writers);
        ProcessEventProcessors.addProcessInstanceCreationStreamProcessors(typedRecordProcessors, zeebeState, writers, bpmnBehaviors, processEngineMetrics);
        ProcessEventProcessors.addProcessInstanceModificationStreamProcessors(typedRecordProcessors, zeebeState, writers, bpmnBehaviors);
        return bpmnStreamProcessor;
    }

    private static void addProcessInstanceCommandProcessor(Writers writers, TypedRecordProcessors typedRecordProcessors, MutableElementInstanceState elementInstanceState) {
        ProcessInstanceCommandProcessor commandProcessor = new ProcessInstanceCommandProcessor(writers, elementInstanceState);
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isProcessInstanceCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, commandProcessor));
    }

    private static void addBpmnStepProcessor(TypedRecordProcessors typedRecordProcessors, BpmnStreamProcessor bpmnStepProcessor) {
        Arrays.stream(ProcessInstanceIntent.values()).filter(ProcessInstanceIntent::isBpmnElementCommand).forEach(intent -> typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE, (Intent)intent, bpmnStepProcessor));
    }

    private static void addMessageStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessMessageSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, BpmnBehaviors bpmnBehaviors, MutableZeebeState zeebeState, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CREATE, new ProcessMessageSubscriptionCreateProcessor(zeebeState.getProcessMessageSubscriptionState(), writers)).onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.CORRELATE, new ProcessMessageSubscriptionCorrelateProcessor(subscriptionState, subscriptionCommandSender, zeebeState, bpmnBehaviors, writers)).onCommand(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, (Intent)ProcessMessageSubscriptionIntent.DELETE, new ProcessMessageSubscriptionDeleteProcessor(subscriptionState, writers)).withListener(new PendingProcessMessageSubscriptionChecker(subscriptionCommandSender, zeebeState.getPendingProcessMessageSubscriptionState()));
    }

    private static void addTimerStreamProcessors(TypedRecordProcessors typedRecordProcessors, DueDateTimerChecker timerChecker, MutableZeebeState zeebeState, BpmnBehaviors bpmnBehaviors, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.TIMER, (Intent)TimerIntent.TRIGGER, new TriggerTimerProcessor(zeebeState, bpmnBehaviors, writers)).onCommand(ValueType.TIMER, (Intent)TimerIntent.CANCEL, new CancelTimerProcessor(zeebeState.getTimerState(), writers.state(), writers.rejection())).withListener(timerChecker);
    }

    private static void addVariableDocumentStreamProcessors(TypedRecordProcessors typedRecordProcessors, BpmnBehaviors bpmnBehaviors, ElementInstanceState elementInstanceState, KeyGenerator keyGenerator, Writers writers) {
        typedRecordProcessors.onCommand(ValueType.VARIABLE_DOCUMENT, (Intent)VariableDocumentIntent.UPDATE, new UpdateVariableDocumentProcessor(elementInstanceState, keyGenerator, bpmnBehaviors.variableBehavior(), writers));
    }

    private static void addProcessInstanceCreationStreamProcessors(TypedRecordProcessors typedRecordProcessors, MutableZeebeState zeebeState, Writers writers, BpmnBehaviors bpmnBehaviors, ProcessEngineMetrics metrics) {
        MutableElementInstanceState elementInstanceState = zeebeState.getElementInstanceState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        CreateProcessInstanceProcessor createProcessor = new CreateProcessInstanceProcessor(zeebeState.getProcessState(), keyGenerator, writers, bpmnBehaviors, metrics);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE, createProcessor);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE_WITH_AWAITING_RESULT, new CreateProcessInstanceWithResultProcessor(createProcessor, elementInstanceState));
    }

    private static void addProcessInstanceModificationStreamProcessors(TypedRecordProcessors typedRecordProcessors, ZeebeState zeebeState, Writers writers, BpmnBehaviors bpmnBehaviors) {
        ProcessInstanceModificationProcessor modificationProcessor = new ProcessInstanceModificationProcessor(writers, zeebeState.getElementInstanceState(), zeebeState.getProcessState(), bpmnBehaviors);
        typedRecordProcessors.onCommand(ValueType.PROCESS_INSTANCE_MODIFICATION, (Intent)ProcessInstanceModificationIntent.MODIFY, modificationProcessor);
    }
}

