/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.el.ExpressionLanguageFactory;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceStateTransitionGuard;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBufferedMessageStartEventBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnDecisionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventPublicationBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnProcessResultSenderBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.MultiInstanceOutputCollectionBehavior;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.ElementActivationBehavior;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.processing.variable.VariableStateEvaluationContextLookup;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;

public final class BpmnBehaviorsImpl
implements BpmnBehaviors {
    private final ExpressionProcessor expressionBehavior;
    private final BpmnDecisionBehavior decisionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventPublicationBehavior eventPublicationBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final ProcessInstanceStateTransitionGuard stateTransitionGuard;
    private final BpmnProcessResultSenderBehavior processResultSenderBehavior;
    private final BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final MultiInstanceOutputCollectionBehavior multiInstanceOutputCollectionBehavior;
    private final CatchEventBehavior catchEventBehavior;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final VariableBehavior variableBehavior;
    private final ElementActivationBehavior elementActivationBehavior;

    public BpmnBehaviorsImpl(MutableZeebeState zeebeState, Writers writers, JobMetrics jobMetrics, ProcessEngineMetrics processEngineMetrics, SubscriptionCommandSender subscriptionCommandSender, int partitionsCount, DueDateTimerChecker timerChecker) {
        this.expressionBehavior = new ExpressionProcessor(ExpressionLanguageFactory.createExpressionLanguage(), new VariableStateEvaluationContextLookup(zeebeState.getVariableState()));
        this.variableBehavior = new VariableBehavior(zeebeState.getVariableState(), writers.state(), zeebeState.getKeyGenerator());
        this.catchEventBehavior = new CatchEventBehavior(zeebeState, zeebeState.getKeyGenerator(), this.expressionBehavior, subscriptionCommandSender, writers.state(), writers.sideEffect(), timerChecker, partitionsCount);
        this.eventTriggerBehavior = new EventTriggerBehavior(zeebeState.getKeyGenerator(), this.catchEventBehavior, writers, zeebeState);
        this.decisionBehavior = new BpmnDecisionBehavior(DecisionEngineFactory.createDecisionEngine(), zeebeState, this.eventTriggerBehavior, writers.state(), zeebeState.getKeyGenerator(), this.expressionBehavior, processEngineMetrics);
        this.stateBehavior = new BpmnStateBehavior(zeebeState, this.variableBehavior);
        this.stateTransitionGuard = new ProcessInstanceStateTransitionGuard(this.stateBehavior);
        this.variableMappingBehavior = new BpmnVariableMappingBehavior(this.expressionBehavior, zeebeState, this.variableBehavior);
        this.eventSubscriptionBehavior = new BpmnEventSubscriptionBehavior(this.catchEventBehavior, this.eventTriggerBehavior, zeebeState);
        this.incidentBehavior = new BpmnIncidentBehavior(zeebeState, zeebeState.getKeyGenerator(), writers.state());
        this.eventPublicationBehavior = new BpmnEventPublicationBehavior(zeebeState, zeebeState.getKeyGenerator(), this.eventTriggerBehavior, this.stateBehavior, writers);
        this.processResultSenderBehavior = new BpmnProcessResultSenderBehavior(zeebeState, writers.response());
        this.bufferedMessageStartEventBehavior = new BpmnBufferedMessageStartEventBehavior(zeebeState, zeebeState.getKeyGenerator(), this.eventTriggerBehavior, this.stateBehavior, writers);
        this.jobBehavior = new BpmnJobBehavior(zeebeState.getKeyGenerator(), zeebeState.getJobState(), writers, this.expressionBehavior, this.stateBehavior, this.incidentBehavior, jobMetrics);
        this.multiInstanceOutputCollectionBehavior = new MultiInstanceOutputCollectionBehavior(this.stateBehavior, this.expressionBehavior());
        this.elementActivationBehavior = new ElementActivationBehavior(zeebeState.getKeyGenerator(), writers, this.catchEventBehavior, zeebeState.getElementInstanceState());
    }

    @Override
    public ExpressionProcessor expressionBehavior() {
        return this.expressionBehavior;
    }

    @Override
    public BpmnDecisionBehavior decisionBehavior() {
        return this.decisionBehavior;
    }

    @Override
    public BpmnVariableMappingBehavior variableMappingBehavior() {
        return this.variableMappingBehavior;
    }

    @Override
    public BpmnEventPublicationBehavior eventPublicationBehavior() {
        return this.eventPublicationBehavior;
    }

    @Override
    public BpmnEventSubscriptionBehavior eventSubscriptionBehavior() {
        return this.eventSubscriptionBehavior;
    }

    @Override
    public BpmnIncidentBehavior incidentBehavior() {
        return this.incidentBehavior;
    }

    @Override
    public BpmnStateBehavior stateBehavior() {
        return this.stateBehavior;
    }

    @Override
    public ProcessInstanceStateTransitionGuard stateTransitionGuard() {
        return this.stateTransitionGuard;
    }

    @Override
    public BpmnProcessResultSenderBehavior processResultSenderBehavior() {
        return this.processResultSenderBehavior;
    }

    @Override
    public BpmnBufferedMessageStartEventBehavior bufferedMessageStartEventBehavior() {
        return this.bufferedMessageStartEventBehavior;
    }

    @Override
    public BpmnJobBehavior jobBehavior() {
        return this.jobBehavior;
    }

    @Override
    public MultiInstanceOutputCollectionBehavior outputCollectionBehavior() {
        return this.multiInstanceOutputCollectionBehavior;
    }

    @Override
    public CatchEventBehavior catchEventBehavior() {
        return this.catchEventBehavior;
    }

    @Override
    public EventTriggerBehavior eventTriggerBehavior() {
        return this.eventTriggerBehavior;
    }

    @Override
    public VariableBehavior variableBehavior() {
        return this.variableBehavior;
    }

    @Override
    public ElementActivationBehavior elementActivationBehavior() {
        return this.elementActivationBehavior;
    }
}

