/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import org.agrona.collections.MutableBoolean;

public final class MessageCorrelator {
    private final MessageState messageState;
    private final SubscriptionCommandSender commandSender;
    private final StateWriter stateWriter;
    private SideEffectWriter sideEffectWriter;

    public MessageCorrelator(MessageState messageState, SubscriptionCommandSender commandSender, StateWriter stateWriter, SideEffectWriter sideEffectWriter) {
        this.messageState = messageState;
        this.commandSender = commandSender;
        this.stateWriter = stateWriter;
        this.sideEffectWriter = sideEffectWriter;
    }

    public boolean correlateNextMessage(long subscriptionKey, MessageSubscriptionRecord subscriptionRecord) {
        MutableBoolean isMessageCorrelated = new MutableBoolean(false);
        this.messageState.visitMessages(subscriptionRecord.getMessageNameBuffer(), subscriptionRecord.getCorrelationKeyBuffer(), storedMessage -> {
            boolean isCorrelated = this.correlateMessage(subscriptionKey, subscriptionRecord, storedMessage);
            isMessageCorrelated.set(isCorrelated);
            return !isCorrelated;
        });
        return isMessageCorrelated.get();
    }

    private boolean correlateMessage(long subscriptionKey, MessageSubscriptionRecord subscriptionRecord, StoredMessage storedMessage) {
        boolean correlateMessage;
        long messageKey = storedMessage.getMessageKey();
        MessageRecord message = storedMessage.getMessage();
        boolean bl = correlateMessage = message.getDeadline() > ActorClock.currentTimeMillis() && !this.messageState.existMessageCorrelation(messageKey, subscriptionRecord.getBpmnProcessIdBuffer());
        if (correlateMessage) {
            subscriptionRecord.setMessageKey(messageKey).setVariables(message.getVariablesBuffer());
            this.stateWriter.appendFollowUpEvent(subscriptionKey, (Intent)MessageSubscriptionIntent.CORRELATING, (RecordValue)subscriptionRecord);
            this.sideEffectWriter.appendSideEffect(() -> this.sendCorrelateCommand(subscriptionRecord));
        }
        return correlateMessage;
    }

    private boolean sendCorrelateCommand(MessageSubscriptionRecord subscriptionRecord) {
        return this.commandSender.correlateProcessMessageSubscription(subscriptionRecord.getProcessInstanceKey(), subscriptionRecord.getElementInstanceKey(), subscriptionRecord.getBpmnProcessIdBuffer(), subscriptionRecord.getMessageNameBuffer(), subscriptionRecord.getMessageKey(), subscriptionRecord.getVariablesBuffer(), subscriptionRecord.getCorrelationKeyBuffer());
    }
}

