/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.api.Task;
import io.camunda.zeebe.engine.api.TaskResult;
import io.camunda.zeebe.engine.api.TaskResultBuilder;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;

public final class MessageTimeToLiveChecker
implements Task {
    private static final MessageRecord EMPTY_DELETE_MESSAGE_COMMAND = new MessageRecord().setName("").setCorrelationKey("").setTimeToLive(-1L);
    private final MessageState messageState;

    public MessageTimeToLiveChecker(MessageState messageState) {
        this.messageState = messageState;
    }

    @Override
    public TaskResult execute(TaskResultBuilder taskResultBuilder) {
        this.messageState.visitMessagesWithDeadlineBefore(ActorClock.currentTimeMillis(), expiredMessageKey -> this.writeDeleteMessageCommand(expiredMessageKey, taskResultBuilder));
        return taskResultBuilder.build();
    }

    private boolean writeDeleteMessageCommand(long expiredMessageKey, TaskResultBuilder taskResultBuilder) {
        return taskResultBuilder.appendCommandRecord(expiredMessageKey, (Intent)MessageIntent.EXPIRE, (UnifiedRecordValue)EMPTY_DELETE_MESSAGE_COMMAND);
    }
}

