/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.processinstance.CreateProcessInstanceProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.instance.AwaitProcessInstanceResultMetadata;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;

public final class CreateProcessInstanceWithResultProcessor
implements CommandProcessor<ProcessInstanceCreationRecord> {
    private final CreateProcessInstanceProcessor createProcessor;
    private final MutableElementInstanceState elementInstanceState;
    private final AwaitProcessInstanceResultMetadata awaitResultMetadata = new AwaitProcessInstanceResultMetadata();
    private final CommandControlWithAwaitResult wrappedController = new CommandControlWithAwaitResult();
    private boolean shouldRespond;

    public CreateProcessInstanceWithResultProcessor(CreateProcessInstanceProcessor createProcessor, MutableElementInstanceState elementInstanceState) {
        this.createProcessor = createProcessor;
        this.elementInstanceState = elementInstanceState;
    }

    @Override
    public boolean onCommand(TypedRecord<ProcessInstanceCreationRecord> command, CommandProcessor.CommandControl<ProcessInstanceCreationRecord> controller) {
        this.wrappedController.setCommand(command).setController(controller);
        this.createProcessor.onCommand(command, this.wrappedController);
        return this.shouldRespond;
    }

    @Override
    public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long key, Intent intent, ProcessInstanceCreationRecord value) {
        this.createProcessor.afterAccept(commandWriter, stateWriter, key, intent, value);
    }

    private class CommandControlWithAwaitResult
    implements CommandProcessor.CommandControl<ProcessInstanceCreationRecord> {
        TypedRecord<ProcessInstanceCreationRecord> command;
        CommandProcessor.CommandControl<ProcessInstanceCreationRecord> controller;

        private CommandControlWithAwaitResult() {
        }

        public CommandControlWithAwaitResult setCommand(TypedRecord<ProcessInstanceCreationRecord> command) {
            this.command = command;
            return this;
        }

        public CommandControlWithAwaitResult setController(CommandProcessor.CommandControl<ProcessInstanceCreationRecord> controller) {
            this.controller = controller;
            return this;
        }

        @Override
        public long accept(Intent newState, ProcessInstanceCreationRecord updatedValue) {
            CreateProcessInstanceWithResultProcessor.this.shouldRespond = false;
            ArrayProperty fetchVariables = this.command.getValue().fetchVariables();
            CreateProcessInstanceWithResultProcessor.this.awaitResultMetadata.setRequestId(this.command.getRequestId()).setRequestStreamId(this.command.getRequestStreamId()).setFetchVariables((ArrayProperty<StringValue>)fetchVariables);
            CreateProcessInstanceWithResultProcessor.this.elementInstanceState.setAwaitResultRequestMetadata(updatedValue.getProcessInstanceKey(), CreateProcessInstanceWithResultProcessor.this.awaitResultMetadata);
            return this.controller.accept(newState, updatedValue);
        }

        @Override
        public void reject(RejectionType type, String reason) {
            CreateProcessInstanceWithResultProcessor.this.shouldRespond = true;
            this.controller.reject(type, reason);
        }
    }
}

