/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.streamprocessor;

import io.camunda.zeebe.engine.api.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;

public final class CommandProcessorImpl<T extends UnifiedRecordValue>
implements TypedRecordProcessor<T>,
CommandProcessor.CommandControl<T> {
    private final CommandProcessor<T> wrappedProcessor;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedCommandWriter commandWriter;
    private boolean isAccepted;
    private long entityKey;
    private Intent newState;
    private T updatedValue;
    private RejectionType rejectionType;
    private String rejectionReason;
    private final TypedResponseWriter responseWriter;

    public CommandProcessorImpl(CommandProcessor<T> commandProcessor, KeyGenerator keyGenerator, Writers writers) {
        this.wrappedProcessor = commandProcessor;
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.commandWriter = writers.command();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
    }

    @Override
    public void processRecord(TypedRecord<T> command) {
        boolean respond;
        this.entityKey = command.getKey();
        boolean shouldRespond = this.wrappedProcessor.onCommand(command, this);
        boolean bl = respond = shouldRespond && command.hasRequestMetadata();
        if (this.isAccepted) {
            this.stateWriter.appendFollowUpEvent(this.entityKey, this.newState, (RecordValue)this.updatedValue);
            this.wrappedProcessor.afterAccept(this.commandWriter, this.stateWriter, this.entityKey, this.newState, this.updatedValue);
            if (respond) {
                this.responseWriter.writeEventOnCommand(this.entityKey, this.newState, (UnpackedObject)this.updatedValue, command);
            }
        } else {
            this.rejectionWriter.appendRejection(command, this.rejectionType, this.rejectionReason);
            if (respond) {
                this.responseWriter.writeRejectionOnCommand(command, this.rejectionType, this.rejectionReason);
            }
        }
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<T> command, Throwable error) {
        return this.wrappedProcessor.tryHandleError(command, error);
    }

    @Override
    public long accept(Intent newState, T updatedValue) {
        if (this.entityKey < 0L) {
            this.entityKey = this.keyGenerator.nextKey();
        }
        this.isAccepted = true;
        this.newState = newState;
        this.updatedValue = updatedValue;
        return this.entityKey;
    }

    @Override
    public void reject(RejectionType type, String reason) {
        this.isAccepted = false;
        this.rejectionType = type;
        this.rejectionReason = reason;
    }
}

