/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.streamprocessor;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.api.CommandResponseWriter;
import io.camunda.zeebe.engine.api.InterPartitionCommandSender;
import io.camunda.zeebe.engine.api.RecordProcessor;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableZeebeState;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.streamprocessor.StreamProcessor;
import io.camunda.zeebe.streamprocessor.StreamProcessorContext;
import io.camunda.zeebe.streamprocessor.StreamProcessorListener;
import io.camunda.zeebe.streamprocessor.StreamProcessorMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class StreamProcessorBuilder {
    private final StreamProcessorContext streamProcessorContext;
    private final List<StreamProcessorLifecycleAware> lifecycleListeners = new ArrayList<StreamProcessorLifecycleAware>();
    private ActorSchedulingService actorSchedulingService;
    private ZeebeDb zeebeDb;
    private Function<MutableZeebeState, EventApplier> eventApplierFactory;
    private int nodeId;
    private List<RecordProcessor> recordProcessors;

    public StreamProcessorBuilder() {
        this.streamProcessorContext = new StreamProcessorContext();
    }

    public StreamProcessorBuilder recordProcessors(List<RecordProcessor> recordProcessors) {
        this.recordProcessors = recordProcessors;
        return this;
    }

    public StreamProcessorBuilder actorSchedulingService(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
        return this;
    }

    public StreamProcessorBuilder nodeId(int nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public StreamProcessorBuilder logStream(LogStream stream) {
        this.streamProcessorContext.logStream(stream);
        return this;
    }

    public StreamProcessorBuilder commandResponseWriter(CommandResponseWriter commandResponseWriter) {
        this.streamProcessorContext.commandResponseWriter(commandResponseWriter);
        return this;
    }

    public StreamProcessorBuilder listener(StreamProcessorListener listener) {
        this.streamProcessorContext.listener(listener);
        return this;
    }

    public StreamProcessorBuilder zeebeDb(ZeebeDb zeebeDb) {
        this.zeebeDb = zeebeDb;
        return this;
    }

    public StreamProcessorBuilder eventApplierFactory(Function<MutableZeebeState, EventApplier> eventApplierFactory) {
        this.eventApplierFactory = eventApplierFactory;
        return this;
    }

    public StreamProcessorBuilder streamProcessorMode(StreamProcessorMode streamProcessorMode) {
        this.streamProcessorContext.processorMode(streamProcessorMode);
        return this;
    }

    public StreamProcessorBuilder partitionCommandSender(InterPartitionCommandSender interPartitionCommandSender) {
        this.streamProcessorContext.partitionCommandSender(interPartitionCommandSender);
        return this;
    }

    public StreamProcessorContext getProcessingContext() {
        return this.streamProcessorContext;
    }

    public ActorSchedulingService getActorSchedulingService() {
        return this.actorSchedulingService;
    }

    public List<StreamProcessorLifecycleAware> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    public ZeebeDb getZeebeDb() {
        return this.zeebeDb;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public List<RecordProcessor> getRecordProcessors() {
        return this.recordProcessors;
    }

    public Function<MutableZeebeState, EventApplier> getEventApplierFactory() {
        return this.eventApplierFactory;
    }

    public StreamProcessor build() {
        this.validate();
        return new StreamProcessor(this);
    }

    private void validate() {
        Objects.requireNonNull(this.actorSchedulingService, "No task scheduler provided.");
        Objects.requireNonNull(this.streamProcessorContext.getLogStream(), "No log stream provided.");
        Objects.requireNonNull(this.zeebeDb, "No database provided.");
        Objects.requireNonNull(this.eventApplierFactory, "No factory for the event supplier provided.");
        if (this.streamProcessorContext.getProcessorMode() == StreamProcessorMode.PROCESSING) {
            Objects.requireNonNull(this.streamProcessorContext.getPartitionCommandSender(), "No partition command sender provided");
        }
        if (this.streamProcessorContext.getMaxCommandsInBatch() < 1) {
            throw new IllegalArgumentException("Batch processing limit must be >= 1 but was %s".formatted(this.streamProcessorContext.getMaxCommandsInBatch()));
        }
    }

    public StreamProcessorBuilder maxCommandsInBatch(int maxCommandsInBatch) {
        this.streamProcessorContext.maxCommandsInBatch(maxCommandsInBatch);
        return this;
    }
}

