/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.metrics.ProcessEngineMetrics;
import io.camunda.zeebe.engine.processing.ProcessEventProcessors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviorsImpl;
import io.camunda.zeebe.engine.processing.deployment.DeploymentCreateProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.CompleteDeploymentDistributionProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributeProcessor;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentRedistributor;
import io.camunda.zeebe.engine.processing.incident.IncidentEventProcessors;
import io.camunda.zeebe.engine.processing.job.JobEventProcessors;
import io.camunda.zeebe.engine.processing.message.MessageEventProcessors;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContext;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.ScheduledTaskDbState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.migration.DbMigrationController;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.FeatureFlags;
import java.util.function.Consumer;

public final class EngineProcessors {
    private EngineProcessors() {
    }

    public static TypedRecordProcessors createEngineProcessors(TypedRecordProcessorContext typedRecordProcessorContext, int partitionsCount, SubscriptionCommandSender subscriptionCommandSender, DeploymentDistributionCommandSender deploymentDistributionCommandSender, Consumer<String> onJobsAvailableCallback, FeatureFlags featureFlags) {
        MutableProcessingState processingState = typedRecordProcessorContext.getProcessingState();
        Writers writers = typedRecordProcessorContext.getWriters();
        TypedRecordProcessors typedRecordProcessors = TypedRecordProcessors.processors(processingState.getKeyGenerator(), writers);
        typedRecordProcessors.withListener(new DbMigrationController(processingState));
        typedRecordProcessors.withListener(processingState);
        int partitionId = typedRecordProcessorContext.getPartitionId();
        EngineConfiguration config = typedRecordProcessorContext.getConfig();
        DueDateTimerChecker timerChecker = new DueDateTimerChecker(processingState.getTimerState(), featureFlags);
        JobMetrics jobMetrics = new JobMetrics(partitionId);
        ProcessEngineMetrics processEngineMetrics = new ProcessEngineMetrics(processingState.getPartitionId());
        subscriptionCommandSender.setWriters(writers);
        BpmnBehaviorsImpl bpmnBehaviors = EngineProcessors.createBehaviors(processingState, writers, subscriptionCommandSender, partitionsCount, timerChecker, jobMetrics, processEngineMetrics);
        EngineProcessors.addDeploymentRelatedProcessorAndServices(bpmnBehaviors, processingState, typedRecordProcessors, writers, partitionsCount, deploymentDistributionCommandSender, processingState.getKeyGenerator());
        EngineProcessors.addMessageProcessors(bpmnBehaviors, subscriptionCommandSender, processingState, typedRecordProcessorContext.getScheduledTaskDbState(), typedRecordProcessors, writers, config, featureFlags);
        TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor = EngineProcessors.addProcessProcessors(processingState, bpmnBehaviors, typedRecordProcessors, subscriptionCommandSender, writers, timerChecker);
        JobEventProcessors.addJobProcessors(typedRecordProcessors, processingState, onJobsAvailableCallback, bpmnBehaviors, writers, jobMetrics);
        EngineProcessors.addIncidentProcessors(processingState, bpmnStreamProcessor, typedRecordProcessors, writers);
        return typedRecordProcessors;
    }

    private static BpmnBehaviorsImpl createBehaviors(MutableProcessingState processingState, Writers writers, SubscriptionCommandSender subscriptionCommandSender, int partitionsCount, DueDateTimerChecker timerChecker, JobMetrics jobMetrics, ProcessEngineMetrics processEngineMetrics) {
        return new BpmnBehaviorsImpl(processingState, writers, jobMetrics, processEngineMetrics, subscriptionCommandSender, partitionsCount, timerChecker);
    }

    private static TypedRecordProcessor<ProcessInstanceRecord> addProcessProcessors(MutableProcessingState processingState, BpmnBehaviorsImpl bpmnBehaviors, TypedRecordProcessors typedRecordProcessors, SubscriptionCommandSender subscriptionCommandSender, Writers writers, DueDateTimerChecker timerChecker) {
        return ProcessEventProcessors.addProcessProcessors(processingState, bpmnBehaviors, typedRecordProcessors, subscriptionCommandSender, timerChecker, writers);
    }

    private static void addDeploymentRelatedProcessorAndServices(BpmnBehaviorsImpl bpmnBehaviors, ProcessingState processingState, TypedRecordProcessors typedRecordProcessors, Writers writers, int partitionsCount, DeploymentDistributionCommandSender deploymentDistributionCommandSender, KeyGenerator keyGenerator) {
        DeploymentCreateProcessor processor = new DeploymentCreateProcessor(processingState, bpmnBehaviors, partitionsCount, writers, deploymentDistributionCommandSender, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE, processor);
        DeploymentRedistributor deploymentRedistributor = new DeploymentRedistributor(deploymentDistributionCommandSender, processingState.getDeploymentState());
        typedRecordProcessors.withListener(deploymentRedistributor);
        DeploymentDistributeProcessor deploymentDistributeProcessor = new DeploymentDistributeProcessor(processingState.getProcessState(), processingState.getMessageStartEventSubscriptionState(), deploymentDistributionCommandSender, writers, keyGenerator);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.DISTRIBUTE, deploymentDistributeProcessor);
        CompleteDeploymentDistributionProcessor completeDeploymentDistributionProcessor = new CompleteDeploymentDistributionProcessor(processingState.getDeploymentState(), writers);
        typedRecordProcessors.onCommand(ValueType.DEPLOYMENT_DISTRIBUTION, (Intent)DeploymentDistributionIntent.COMPLETE, completeDeploymentDistributionProcessor);
    }

    private static void addIncidentProcessors(ProcessingState processingState, TypedRecordProcessor<ProcessInstanceRecord> bpmnStreamProcessor, TypedRecordProcessors typedRecordProcessors, Writers writers) {
        IncidentEventProcessors.addProcessors(typedRecordProcessors, processingState, bpmnStreamProcessor, writers);
    }

    private static void addMessageProcessors(BpmnBehaviorsImpl bpmnBehaviors, SubscriptionCommandSender subscriptionCommandSender, MutableProcessingState processingState, ScheduledTaskDbState scheduledTaskDbState, TypedRecordProcessors typedRecordProcessors, Writers writers, EngineConfiguration config, FeatureFlags featureFlags) {
        MessageEventProcessors.addMessageProcessors(bpmnBehaviors, typedRecordProcessors, processingState, scheduledTaskDbState, subscriptionCommandSender, writers, config, featureFlags);
    }
}

