/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.api.ProcessingScheduleService;
import io.camunda.zeebe.engine.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.engine.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.message.MessageTimeToLiveChecker;
import io.camunda.zeebe.engine.processing.message.PendingMessageSubscriptionChecker;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.mutable.MutablePendingMessageSubscriptionState;
import java.time.Duration;

public final class MessageObserver
implements StreamProcessorLifecycleAware {
    public static final Duration SUBSCRIPTION_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration SUBSCRIPTION_CHECK_INTERVAL = Duration.ofSeconds(30L);
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final MessageState messageState;
    private final MutablePendingMessageSubscriptionState pendingState;
    private final int messagesTtlCheckerBatchLimit;
    private final Duration messagesTtlCheckerInterval;
    private final boolean enableMessageTtlCheckerAsync;

    public MessageObserver(MessageState messageState, MutablePendingMessageSubscriptionState pendingState, SubscriptionCommandSender subscriptionCommandSender, Duration messagesTtlCheckerInterval, int messagesTtlCheckerBatchLimit, boolean enableMessageTtlCheckerAsync) {
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.messageState = messageState;
        this.pendingState = pendingState;
        this.messagesTtlCheckerInterval = messagesTtlCheckerInterval;
        this.messagesTtlCheckerBatchLimit = messagesTtlCheckerBatchLimit;
        this.enableMessageTtlCheckerAsync = enableMessageTtlCheckerAsync;
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        ProcessingScheduleService scheduleService = context.getScheduleService();
        MessageTimeToLiveChecker timeToLiveChecker = new MessageTimeToLiveChecker(this.messagesTtlCheckerInterval, this.messagesTtlCheckerBatchLimit, this.enableMessageTtlCheckerAsync, scheduleService, this.messageState);
        if (this.enableMessageTtlCheckerAsync) {
            scheduleService.runDelayedAsync(this.messagesTtlCheckerInterval, timeToLiveChecker);
        } else {
            scheduleService.runDelayed(this.messagesTtlCheckerInterval, timeToLiveChecker);
        }
        PendingMessageSubscriptionChecker pendingSubscriptionChecker = new PendingMessageSubscriptionChecker(this.subscriptionCommandSender, this.pendingState, SUBSCRIPTION_TIMEOUT.toMillis());
        scheduleService.runAtFixedRate(SUBSCRIPTION_CHECK_INTERVAL, pendingSubscriptionChecker);
    }
}

