/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordProcessorMap;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContextImpl;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.ZeebeDbState;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.engine.state.processing.DbBlackListState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.stream.api.EmptyProcessingResult;
import io.camunda.zeebe.stream.api.ProcessingResult;
import io.camunda.zeebe.stream.api.ProcessingResultBuilder;
import io.camunda.zeebe.stream.api.RecordProcessor;
import io.camunda.zeebe.stream.api.RecordProcessorContext;
import io.camunda.zeebe.stream.api.SideEffectProducer;
import io.camunda.zeebe.stream.api.records.ExceededBatchRecordSizeException;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class Engine
implements RecordProcessor {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private static final String ERROR_MESSAGE_PROCESSOR_NOT_FOUND = "Expected to find processor for record '{}', but caught an exception. Skip this record.";
    private static final String ERROR_MESSAGE_PROCESSING_EXCEPTION_OCCURRED = "Expected to process record '%s' without errors, but exception occurred with message '%s'.";
    private static final EnumSet<ValueType> SUPPORTED_VALUETYPES = EnumSet.range(ValueType.JOB, ValueType.PROCESS_INSTANCE_MODIFICATION);
    private EventApplier eventApplier;
    private RecordProcessorMap recordProcessorMap;
    private ZeebeDbState zeebeState;
    private final ErrorRecord errorRecord = new ErrorRecord();
    private final ProcessingResultBuilderMutex resultBuilderMutex = new ProcessingResultBuilderMutex();
    private Writers writers;
    private TypedRecordProcessorFactory typedRecordProcessorFactory;

    public Engine() {
    }

    public Engine(TypedRecordProcessorFactory typedRecordProcessorFactory) {
        this.typedRecordProcessorFactory = typedRecordProcessorFactory;
    }

    public void init(RecordProcessorContext recordProcessorContext) {
        this.zeebeState = new ZeebeDbState(recordProcessorContext.getPartitionId(), (ZeebeDb<ZbColumnFamilies>)recordProcessorContext.getZeebeDb(), recordProcessorContext.getTransactionContext(), recordProcessorContext.getKeyGenerator());
        this.eventApplier = new EventAppliers(this.zeebeState);
        this.writers = new Writers(this.resultBuilderMutex, this.eventApplier);
        TypedRecordProcessorContextImpl typedProcessorContext = new TypedRecordProcessorContextImpl(recordProcessorContext.getPartitionId(), recordProcessorContext.getScheduleService(), this.zeebeState, this.writers, recordProcessorContext.getPartitionCommandSender());
        TypedRecordProcessors typedRecordProcessors = this.typedRecordProcessorFactory.createProcessors(typedProcessorContext);
        recordProcessorContext.addLifecycleListeners(typedRecordProcessors.getLifecycleListeners());
        this.recordProcessorMap = typedRecordProcessors.getRecordProcessorMap();
    }

    public boolean accepts(ValueType valueType) {
        return SUPPORTED_VALUETYPES.contains(valueType);
    }

    public void replay(TypedRecord event) {
        this.eventApplier.applyState(event.getKey(), event.getIntent(), (RecordValue)event.getValue());
    }

    public ProcessingResult process(TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        try (ProcessingResultBuilderScope scope = new ProcessingResultBuilderScope(processingResultBuilder);){
            boolean isNotOnBlacklist;
            TypedRecordProcessor currentProcessor = null;
            TypedRecord typedCommand = record;
            try {
                currentProcessor = this.recordProcessorMap.get(typedCommand.getRecordType(), typedCommand.getValueType(), typedCommand.getIntent().value());
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_PROCESSOR_NOT_FOUND, (Object)typedCommand, (Object)e);
            }
            if (currentProcessor == null) {
                ProcessingResult e = EmptyProcessingResult.INSTANCE;
                return e;
            }
            boolean bl = isNotOnBlacklist = !this.zeebeState.getBlackListState().isOnBlacklist(typedCommand);
            if (isNotOnBlacklist) {
                currentProcessor.processRecord(record, sep -> {
                    processingResultBuilder.resetPostCommitTasks();
                    processingResultBuilder.appendPostCommitTask(() -> ((SideEffectProducer)sep).flush());
                });
            }
        }
        return processingResultBuilder.build();
    }

    public ProcessingResult onProcessingError(Throwable processingException, TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        try (ProcessingResultBuilderScope scope = new ProcessingResultBuilderScope(processingResultBuilder);){
            TypedRecordProcessor.ProcessingError error;
            TypedRecord typedCommand = record;
            TypedRecordProcessor processor = null;
            try {
                processor = this.recordProcessorMap.get(typedCommand.getRecordType(), typedCommand.getValueType(), typedCommand.getIntent().value());
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_PROCESSOR_NOT_FOUND, (Object)typedCommand, (Object)e);
            }
            TypedRecordProcessor.ProcessingError processingError = error = processor == null ? TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR : processor.tryHandleError(record, processingException);
            if (error == TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR) {
                this.handleUnexpectedError(processingException, record);
            }
        }
        return processingResultBuilder.build();
    }

    private void handleUnexpectedError(Throwable processingException, TypedRecord record) {
        String errorMessage = String.format(ERROR_MESSAGE_PROCESSING_EXCEPTION_OCCURRED, record, processingException.getMessage());
        LOG.error(errorMessage, processingException);
        if (processingException instanceof ExceededBatchRecordSizeException) {
            this.writers.rejection().appendRejection((TypedRecord<? extends RecordValue>)record, RejectionType.EXCEEDED_BATCH_RECORD_SIZE, "");
            this.writers.response().writeRejectionOnCommand(record, RejectionType.EXCEEDED_BATCH_RECORD_SIZE, "");
        } else {
            this.writers.rejection().appendRejection((TypedRecord<? extends RecordValue>)record, RejectionType.PROCESSING_ERROR, errorMessage);
            this.writers.response().writeRejectionOnCommand(record, RejectionType.PROCESSING_ERROR, errorMessage);
        }
        this.errorRecord.initErrorRecord(processingException, record.getPosition());
        if (DbBlackListState.shouldBeBlacklisted(record.getIntent())) {
            if (record.getValue() instanceof ProcessInstanceRelated) {
                long processInstanceKey = ((ProcessInstanceRelated)record.getValue()).getProcessInstanceKey();
                this.errorRecord.setProcessInstanceKey(processInstanceKey);
            }
            this.writers.state().appendFollowUpEvent(record.getKey(), (Intent)ErrorIntent.CREATED, (RecordValue)this.errorRecord);
        }
    }

    private static final class ProcessingResultBuilderMutex
    implements Supplier<ProcessingResultBuilder> {
        private ProcessingResultBuilder resultBuilder;

        private ProcessingResultBuilderMutex() {
        }

        private void setResultBuilder(ProcessingResultBuilder resultBuilder) {
            this.resultBuilder = Objects.requireNonNull(resultBuilder);
        }

        private void unsetResultBuilder() {
            this.resultBuilder = null;
        }

        @Override
        public ProcessingResultBuilder get() {
            if (this.resultBuilder == null) {
                throw new IllegalStateException("Attempt to retrieve resultBuilder out of scope.");
            }
            return this.resultBuilder;
        }
    }

    private final class ProcessingResultBuilderScope
    implements AutoCloseable {
        private ProcessingResultBuilderScope(ProcessingResultBuilder processingResultBuilder) {
            Engine.this.resultBuilderMutex.setResultBuilder(processingResultBuilder);
        }

        @Override
        public void close() {
            Engine.this.resultBuilderMutex.unsetResultBuilder();
        }
    }
}

