/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.analyzers.CatchEventAnalyzer;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.value.escalation.EscalationRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.EscalationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.EnsureUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.commons.lang3.StringUtils;

public final class BpmnEventPublicationBehavior {
    private final ElementInstanceState elementInstanceState;
    private final EventHandle eventHandle;
    private final CatchEventAnalyzer catchEventAnalyzer;
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;

    public BpmnEventPublicationBehavior(ZeebeState zeebeState, KeyGenerator keyGenerator, EventTriggerBehavior eventTriggerBehavior, BpmnStateBehavior stateBehavior, Writers writers) {
        this.elementInstanceState = zeebeState.getElementInstanceState();
        this.eventHandle = new EventHandle(keyGenerator, zeebeState.getEventScopeInstanceState(), writers, zeebeState.getProcessState(), eventTriggerBehavior, stateBehavior);
        this.catchEventAnalyzer = new CatchEventAnalyzer(zeebeState.getProcessState(), this.elementInstanceState);
        this.stateWriter = writers.state();
        this.keyGenerator = keyGenerator;
    }

    public void throwErrorEvent(CatchEventAnalyzer.CatchEventTuple catchEventTuple, Map<String, Object> variables, String errorMessage) {
        ElementInstance eventScopeInstance = catchEventTuple.getElementInstance();
        ExecutableCatchEvent catchEvent = catchEventTuple.getCatchEvent();
        ExecutableError error = catchEvent.getError();
        Optional<String> errorCodeOptional = error.getErrorCode().map(BufferUtil::bufferAsString);
        error.getErrorCodeVariable().filter(StringUtils::isNotBlank).ifPresent(errorCodeVariable -> errorCodeOptional.ifPresent(errorCode -> variables.put((String)errorCodeVariable, errorCode)));
        error.getErrorMessageVariable().filter(StringUtils::isNotBlank).ifPresent(errorMessageVariable -> variables.put((String)errorMessageVariable, errorMessage));
        if (this.eventHandle.canTriggerElement(eventScopeInstance, catchEvent.getId())) {
            this.eventHandle.activateElement(catchEvent, eventScopeInstance.getKey(), eventScopeInstance.getValue(), (DirectBuffer)new UnsafeBuffer(MsgPackConverter.convertToMsgPack(variables)));
        }
    }

    public Either<Failure, CatchEventAnalyzer.CatchEventTuple> findErrorCatchEvent(DirectBuffer errorCode, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(context.getFlowScopeKey());
        return this.catchEventAnalyzer.findErrorCatchEvent(errorCode, flowScopeInstance, Optional.empty());
    }

    public Optional<CatchEventAnalyzer.CatchEventTuple> findEscalationCatchEvent(DirectBuffer escalationCode, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(context.getFlowScopeKey());
        return this.catchEventAnalyzer.findEscalationCatchEvent(escalationCode, flowScopeInstance);
    }

    public boolean throwEscalationEvent(DirectBuffer throwElementId, DirectBuffer escalationCode, BpmnElementContext context) {
        EnsureUtil.ensureNotNullOrEmpty((String)"escalationCode", (DirectBuffer)escalationCode);
        EscalationRecord record = new EscalationRecord();
        record.setThrowElementId(throwElementId);
        record.setEscalationCode(BufferUtil.bufferAsString((DirectBuffer)escalationCode));
        record.setProcessInstanceKey(context.getProcessInstanceKey());
        Optional<CatchEventAnalyzer.CatchEventTuple> escalationCatchEvent = this.findEscalationCatchEvent(escalationCode, context);
        boolean canBeCompleted = true;
        boolean escalated = false;
        long key = this.keyGenerator.nextKey();
        if (escalationCatchEvent.isPresent()) {
            CatchEventAnalyzer.CatchEventTuple catchEventTuple = escalationCatchEvent.get();
            ElementInstance eventScopeInstance = catchEventTuple.getElementInstance();
            ExecutableCatchEvent catchEvent = catchEventTuple.getCatchEvent();
            record.setCatchElementId(catchEvent.getId());
            boolean bl = canBeCompleted = !catchEvent.isInterrupting();
            if (this.eventHandle.canTriggerElement(eventScopeInstance, catchEvent.getId())) {
                this.eventHandle.activateElement(catchEvent, eventScopeInstance.getKey(), eventScopeInstance.getValue());
                this.stateWriter.appendFollowUpEvent(key, (Intent)EscalationIntent.ESCALATED, (RecordValue)record);
                escalated = true;
            }
        }
        if (!escalated) {
            this.stateWriter.appendFollowUpEvent(key, (Intent)EscalationIntent.NOT_ESCALATED, (RecordValue)record);
        }
        return canBeCompleted;
    }
}

