/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.StartEventSubscriptionManager;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionBehavior;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectQueue;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffects;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.SideEffectProducer;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import java.util.List;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class DeploymentCreateProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    private static final String COULD_NOT_CREATE_TIMER_MESSAGE = "Expected to create timer for start event, but encountered the following error: %s";
    private final SideEffectQueue sideEffects = new SideEffectQueue();
    private final DeploymentTransformer deploymentTransformer;
    private final ProcessState processState;
    private final TimerInstanceState timerInstanceState;
    private final CatchEventBehavior catchEventBehavior;
    private final KeyGenerator keyGenerator;
    private final ExpressionProcessor expressionProcessor;
    private final StateWriter stateWriter;
    private final StartEventSubscriptionManager startEventSubscriptionManager;
    private final DeploymentDistributionBehavior deploymentDistributionBehavior;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;

    public DeploymentCreateProcessor(ZeebeState zeebeState, BpmnBehaviors bpmnBehaviors, int partitionsCount, Writers writers, DeploymentDistributionCommandSender deploymentDistributionCommandSender, KeyGenerator keyGenerator) {
        this.processState = zeebeState.getProcessState();
        this.timerInstanceState = zeebeState.getTimerState();
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.catchEventBehavior = bpmnBehaviors.catchEventBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.deploymentTransformer = new DeploymentTransformer(this.stateWriter, zeebeState, this.expressionProcessor, keyGenerator);
        this.startEventSubscriptionManager = new StartEventSubscriptionManager(zeebeState, keyGenerator);
        this.deploymentDistributionBehavior = new DeploymentDistributionBehavior(writers, partitionsCount, deploymentDistributionCommandSender);
    }

    @Override
    public void processRecord(TypedRecord<DeploymentRecord> command, Consumer<SideEffectProducer> sideEffect) {
        sideEffect.accept(this.sideEffects);
        DeploymentRecord deploymentEvent = (DeploymentRecord)command.getValue();
        boolean accepted = this.deploymentTransformer.transform(deploymentEvent);
        if (accepted) {
            long key = this.keyGenerator.nextKey();
            try {
                this.createTimerIfTimerStartEvent(command, this.sideEffects);
            }
            catch (RuntimeException e) {
                String reason = String.format(COULD_NOT_CREATE_TIMER_MESSAGE, e.getMessage());
                this.responseWriter.writeRejectionOnCommand(command, RejectionType.PROCESSING_ERROR, reason);
                this.rejectionWriter.appendRejection(command, RejectionType.PROCESSING_ERROR, reason);
                return;
            }
            this.responseWriter.writeEventOnCommand(key, (Intent)DeploymentIntent.CREATED, (UnpackedObject)deploymentEvent, command);
            this.stateWriter.appendFollowUpEvent(key, (Intent)DeploymentIntent.CREATED, (RecordValue)deploymentEvent);
            this.deploymentDistributionBehavior.distributeDeployment(deploymentEvent, key, this.sideEffects);
            this.startEventSubscriptionManager.tryReOpenStartEventSubscription(deploymentEvent, this.stateWriter);
        } else {
            this.responseWriter.writeRejectionOnCommand(command, this.deploymentTransformer.getRejectionType(), this.deploymentTransformer.getRejectionReason());
            this.rejectionWriter.appendRejection(command, this.deploymentTransformer.getRejectionType(), this.deploymentTransformer.getRejectionReason());
        }
    }

    private void createTimerIfTimerStartEvent(TypedRecord<DeploymentRecord> record, SideEffects sideEffects) {
        for (ProcessMetadata processMetadata : ((DeploymentRecord)record.getValue()).processesMetadata()) {
            if (processMetadata.isDuplicate()) continue;
            List<ExecutableStartEvent> startEvents = this.processState.getProcessByKey(processMetadata.getKey()).getProcess().getStartEvents();
            this.unsubscribeFromPreviousTimers(processMetadata);
            this.subscribeToTimerStartEventIfExists(sideEffects, processMetadata, startEvents);
        }
    }

    private void subscribeToTimerStartEventIfExists(SideEffects sideEffects, ProcessMetadata processMetadata, List<ExecutableStartEvent> startEvents) {
        for (ExecutableCatchEventElement executableCatchEventElement : startEvents) {
            if (!executableCatchEventElement.isTimer()) continue;
            long scopeKey = -1L;
            Either<Failure, Timer> timerOrError = executableCatchEventElement.getTimerFactory().apply(this.expressionProcessor, -1L);
            if (timerOrError.isLeft()) {
                throw new ExpressionProcessor.EvaluationException(((Failure)timerOrError.getLeft()).getMessage());
            }
            this.catchEventBehavior.subscribeToTimerEvent(-1L, -1L, processMetadata.getKey(), executableCatchEventElement.getId(), (Timer)timerOrError.get(), sideEffects);
        }
    }

    private void unsubscribeFromPreviousTimers(ProcessMetadata processRecord) {
        this.timerInstanceState.forEachTimerForElementInstance(-1L, timer -> this.unsubscribeFromPreviousTimer(processRecord, (TimerInstance)((Object)timer)));
    }

    private void unsubscribeFromPreviousTimer(ProcessMetadata processMetadata, TimerInstance timer) {
        DirectBuffer timerBpmnId = this.processState.getProcessByKey(timer.getProcessDefinitionKey()).getBpmnProcessId();
        if (timerBpmnId.equals(processMetadata.getBpmnProcessIdBuffer())) {
            this.catchEventBehavior.unsubscribeFromTimerEvent(timer);
        }
    }
}

