/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLink;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe.ErrorTransformer;
import io.camunda.zeebe.engine.processing.timer.CronTimer;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.LinkEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Signal;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeError;
import io.camunda.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.camunda.zeebe.model.bpmn.util.time.TimeDateTimer;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.time.format.DateTimeParseException;

public final class CatchEventTransformer
implements ModelElementTransformer<CatchEvent> {
    private final ErrorTransformer errorTransformer = new ErrorTransformer();

    @Override
    public Class<CatchEvent> getType() {
        return CatchEvent.class;
    }

    @Override
    public void transform(CatchEvent element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableCatchEventElement executableElement = process.getElementById(element.getId(), ExecutableCatchEventElement.class);
        if (!element.getEventDefinitions().isEmpty()) {
            this.transformEventDefinition(element, context, executableElement);
        }
    }

    private void transformEventDefinition(CatchEvent element, TransformContext context, ExecutableCatchEventElement executableElement) {
        EventDefinition eventDefinition = (EventDefinition)element.getEventDefinitions().iterator().next();
        if (eventDefinition instanceof MessageEventDefinition) {
            this.transformMessageEventDefinition(context, executableElement, (MessageEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof TimerEventDefinition) {
            ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
            TimerEventDefinition timerDefinition = (TimerEventDefinition)eventDefinition;
            this.transformTimerEventDefinition(expressionLanguage, executableElement, timerDefinition);
        } else if (eventDefinition instanceof ErrorEventDefinition) {
            this.transformErrorEventDefinition(context, executableElement, (ErrorEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof LinkEventDefinition) {
            this.transformLinkEventDefinition(context, executableElement, (LinkEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof EscalationEventDefinition) {
            this.transformEscalationEventDefinition(context, executableElement, (EscalationEventDefinition)eventDefinition);
        } else if (eventDefinition instanceof SignalEventDefinition) {
            this.transformSignalEventDefinition(context, executableElement, (SignalEventDefinition)eventDefinition);
        }
    }

    private void transformMessageEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, MessageEventDefinition messageEventDefinition) {
        Message message = messageEventDefinition.getMessage();
        ExecutableMessage executableMessage = context.getMessage(message.getId());
        executableElement.setMessage(executableMessage);
        executableElement.setEventType(BpmnEventType.MESSAGE);
    }

    private void transformTimerEventDefinition(ExpressionLanguage expressionLanguage, ExecutableCatchEventElement executableElement, TimerEventDefinition timerEventDefinition) {
        executableElement.setEventType(BpmnEventType.TIMER);
        if (timerEventDefinition.getTimeDuration() != null) {
            String duration = timerEventDefinition.getTimeDuration().getTextContent();
            Expression expression = expressionLanguage.parseExpression(duration);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> expressionProcessor.evaluateIntervalExpression(expression, (long)scopeKey).map(interval -> new RepeatingInterval(1, interval)));
        } else if (timerEventDefinition.getTimeCycle() != null) {
            String cycle = timerEventDefinition.getTimeCycle().getTextContent();
            Expression expression = expressionLanguage.parseExpression(cycle);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> {
                try {
                    return expressionProcessor.evaluateStringExpression(expression, (long)scopeKey).map(text -> {
                        if (text.startsWith("R")) {
                            return RepeatingInterval.parse((String)text);
                        }
                        return CronTimer.parse(text);
                    });
                }
                catch (DateTimeParseException e) {
                    return Either.left((Object)new Failure(e.getMessage(), ErrorType.EXTRACT_VALUE_ERROR, (long)scopeKey));
                }
            });
        } else if (timerEventDefinition.getTimeDate() != null) {
            String timeDate = timerEventDefinition.getTimeDate().getTextContent();
            Expression expression = expressionLanguage.parseExpression(timeDate);
            executableElement.setTimerFactory((expressionProcessor, scopeKey) -> expressionProcessor.evaluateDateTimeExpression(expression, (Long)scopeKey).map(TimeDateTimer::new));
        }
    }

    private void transformErrorEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, ErrorEventDefinition errorEventDefinition) {
        ExecutableError executableError;
        Error error = errorEventDefinition.getError();
        if (error == null) {
            executableError = new ExecutableError("");
            executableError.setErrorCode(BufferUtil.wrapString((String)""));
        } else {
            executableError = context.getError(error.getId());
        }
        this.transformError(errorEventDefinition, executableError);
        executableElement.setError(executableError);
        executableElement.setEventType(BpmnEventType.ERROR);
    }

    private void transformError(ErrorEventDefinition element, ExecutableError executableElement) {
        ZeebeError error = (ZeebeError)element.getSingleExtensionElement(ZeebeError.class);
        this.errorTransformer.transform(executableElement, error);
    }

    public void transformLinkEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, LinkEventDefinition linkEventDefinition) {
        executableElement.setLink(true);
        executableElement.setEventType(BpmnEventType.LINK);
        ExecutableLink link = new ExecutableLink(linkEventDefinition.getId());
        link.setName(BufferUtil.wrapString((String)linkEventDefinition.getName()));
        link.setCatchEvent(executableElement);
        context.addLink(link);
    }

    private void transformEscalationEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, EscalationEventDefinition escalationEventDefinition) {
        ExecutableEscalation executableEscalation;
        Escalation escalation = escalationEventDefinition.getEscalation();
        if (escalation == null) {
            executableEscalation = new ExecutableEscalation("");
            executableEscalation.setEscalationCode(BufferUtil.wrapString((String)""));
        } else {
            executableEscalation = context.getEscalation(escalation.getId());
        }
        executableElement.setEscalation(executableEscalation);
        executableElement.setEventType(BpmnEventType.ESCALATION);
    }

    private void transformSignalEventDefinition(TransformContext context, ExecutableCatchEventElement executableElement, SignalEventDefinition signalEventDefinition) {
        Signal signal = signalEventDefinition.getSignal();
        ExecutableSignal executableSignal = context.getSignal(signal.getId());
        executableElement.setSignal(executableSignal);
        executableElement.setEventType(BpmnEventType.SIGNAL);
    }
}

