/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.job.JobAcceptFunction;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.stream.api.SideEffectProducer;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.function.Consumer;

final class DefaultJobCommandPreconditionGuard {
    private static final String NO_JOB_FOUND_MESSAGE = "Expected to %s job with key '%d', but no such job was found";
    private static final String INVALID_JOB_STATE_MESSAGE = "Expected to %s job with key '%d', but it is in state '%s'";
    private final String intent;
    private final JobState state;
    private final JobAcceptFunction acceptCommand;

    public DefaultJobCommandPreconditionGuard(String intent, JobState state, JobAcceptFunction acceptCommand) {
        this.intent = intent;
        this.state = state;
        this.acceptCommand = acceptCommand;
    }

    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        return this.onCommand(command, commandControl, sideEffectProducer -> {});
    }

    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl, Consumer<SideEffectProducer> sideEffect) {
        long jobKey = command.getKey();
        JobState.State jobState = this.state.getState(jobKey);
        if (jobState == JobState.State.ACTIVATABLE || jobState == JobState.State.ACTIVATED) {
            this.acceptCommand.accept(command, commandControl, sideEffect);
        } else if (jobState == JobState.State.NOT_FOUND) {
            String message = String.format(NO_JOB_FOUND_MESSAGE, this.intent, jobKey);
            commandControl.reject(RejectionType.NOT_FOUND, message);
        } else {
            String message = String.format(INVALID_JOB_STATE_MESSAGE, new Object[]{this.intent, jobKey, jobState});
            commandControl.reject(RejectionType.INVALID_STATE, message);
        }
        return true;
    }
}

