/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.scheduling.Task;
import io.camunda.zeebe.stream.api.scheduling.TaskResult;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;

public final class MessageTimeToLiveChecker
implements Task {
    private final MessageState messageState;
    private final MessageRecord deleteMessageCommand = new MessageRecord();

    public MessageTimeToLiveChecker(MessageState messageState) {
        this.messageState = messageState;
    }

    public TaskResult execute(TaskResultBuilder taskResultBuilder) {
        this.messageState.visitMessagesWithDeadlineBefore(ActorClock.currentTimeMillis(), message -> this.writeDeleteMessageCommand(message, taskResultBuilder));
        return taskResultBuilder.build();
    }

    private boolean writeDeleteMessageCommand(StoredMessage storedMessage, TaskResultBuilder taskResultBuilder) {
        MessageRecord message = storedMessage.getMessage();
        this.deleteMessageCommand.reset();
        this.deleteMessageCommand.setName(message.getName()).setCorrelationKey(message.getCorrelationKey()).setTimeToLive(message.getTimeToLive()).setVariables(message.getVariablesBuffer());
        if (message.hasMessageId()) {
            this.deleteMessageCommand.setMessageId(message.getMessageIdBuffer());
        }
        return taskResultBuilder.appendCommandRecord(storedMessage.getMessageKey(), (Intent)MessageIntent.EXPIRE, (UnifiedRecordValue)this.deleteMessageCommand);
    }
}

