/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import org.agrona.DirectBuffer;

public final class BufferedStartMessageEventStateApplier {
    private final ProcessState processState;
    private final MutableMessageState messageState;

    public BufferedStartMessageEventStateApplier(ProcessState processState, MutableMessageState messageState) {
        this.processState = processState;
        this.messageState = messageState;
    }

    public void removeMessageLock(ProcessInstanceRecord record) {
        ExecutableFlowElementContainer processElement;
        if (record.getBpmnElementType() == BpmnElementType.PROCESS && (processElement = this.getProcessElement(record)).hasMessageStartEvent()) {
            this.removeProcessInstanceMessageLock(record);
        }
    }

    private ExecutableFlowElementContainer getProcessElement(ProcessInstanceRecord record) {
        return this.processState.getFlowElement(record.getProcessDefinitionKey(), record.getElementIdBuffer(), ExecutableFlowElementContainer.class);
    }

    private void removeProcessInstanceMessageLock(ProcessInstanceRecord record) {
        long processInstanceKey = record.getProcessInstanceKey();
        DirectBuffer correlationKey = this.messageState.getProcessInstanceCorrelationKey(processInstanceKey);
        if (correlationKey != null) {
            this.messageState.removeProcessInstanceCorrelationKey(processInstanceKey);
            this.messageState.removeActiveProcessInstance(record.getBpmnProcessIdBuffer(), correlationKey);
        }
    }
}

