/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.message.TransientSubscriptionCommandState;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.util.buffer.BufferUtil;

final class PendingProcessMessageSubscriptionState {
    private final TransientSubscriptionCommandState transientState = new TransientSubscriptionCommandState();
    private final ProcessMessageSubscriptionState persistentState;

    PendingProcessMessageSubscriptionState(ProcessMessageSubscriptionState persistentState) {
        this.persistentState = persistentState;
    }

    final void visitSubscriptionBefore(long deadline, ProcessMessageSubscriptionState.ProcessMessageSubscriptionVisitor visitor) {
        for (TransientSubscriptionCommandState.CommandEntry commandEntry : this.transientState.getEntriesBefore(deadline)) {
            ProcessMessageSubscription subscription = this.persistentState.getSubscription(commandEntry.getElementInstanceKey(), BufferUtil.wrapString((String)commandEntry.getMessageName()));
            visitor.visit(subscription);
        }
    }

    final void updateSentTime(ProcessMessageSubscriptionRecord record, long commandSentTime) {
        TransientSubscriptionCommandState.CommandEntry updatedEntry = this.buildCommandEntry(record, commandSentTime);
        this.transientState.updateCommandSentTime(updatedEntry);
    }

    final void add(ProcessMessageSubscriptionRecord record) {
        this.add(record, ActorClock.currentTimeMillis());
    }

    final void add(ProcessMessageSubscriptionRecord record, long commandSentTime) {
        this.transientState.add(this.buildCommandEntry(record, commandSentTime));
    }

    final void remove(ProcessMessageSubscriptionRecord record) {
        this.transientState.remove(this.buildCommandEntry(record, 0L));
    }

    private TransientSubscriptionCommandState.CommandEntry buildCommandEntry(ProcessMessageSubscriptionRecord record, long commandSentTime) {
        return new TransientSubscriptionCommandState.CommandEntry(record.getElementInstanceKey(), record.getMessageName(), commandSentTime);
    }
}

