/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class TransientSubscriptionCommandState {
    private final List<CommandEntry> transientState = new ArrayList<CommandEntry>();

    public final void add(CommandEntry commandEntryToAdd) {
        this.removeEqualEntry(commandEntryToAdd);
        this.transientState.add(commandEntryToAdd);
    }

    public final void updateCommandSentTime(CommandEntry updatedCommandEntry) {
        if (this.removeEqualEntry(updatedCommandEntry)) {
            this.add(updatedCommandEntry);
        }
    }

    public final void remove(CommandEntry templateOfCommandEntryToBeRemoved) {
        this.removeEqualEntry(templateOfCommandEntryToBeRemoved);
    }

    private boolean removeEqualEntry(CommandEntry templateCommandEntry) {
        return this.transientState.removeIf(templateCommandEntry::equals);
    }

    final Iterable<CommandEntry> getEntriesBefore(long deadline) {
        return this.transientState.stream().sorted().takeWhile(commandEntry -> commandEntry.getCommandSentTime() < deadline).collect(Collectors.toList());
    }

    public static final class CommandEntry
    implements Comparable<CommandEntry> {
        private final long elementInstanceKey;
        private final String messageName;
        private final long commandSentTime;

        public CommandEntry(long elementInstanceKey, String messageName, long commandSentTime) {
            this.elementInstanceKey = elementInstanceKey;
            this.messageName = messageName;
            this.commandSentTime = commandSentTime;
        }

        public long getElementInstanceKey() {
            return this.elementInstanceKey;
        }

        public String getMessageName() {
            return this.messageName;
        }

        public long getCommandSentTime() {
            return this.commandSentTime;
        }

        public int hashCode() {
            return (int)(this.elementInstanceKey ^ this.elementInstanceKey >>> 32);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandEntry commandEntry = (CommandEntry)o;
            if (this.elementInstanceKey != commandEntry.elementInstanceKey) {
                return false;
            }
            return this.messageName.equals(commandEntry.messageName);
        }

        public String toString() {
            return "Entry{elementInstanceKey=" + this.elementInstanceKey + ", messageName='" + this.messageName + "', commandSentTime=" + this.commandSentTime + "}";
        }

        @Override
        public int compareTo(CommandEntry commandEntry) {
            return (int)(this.commandSentTime - commandEntry.commandSentTime);
        }
    }
}

