/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.processing;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.metrics.BlacklistMetrics;
import io.camunda.zeebe.engine.state.mutable.MutableBlackListState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class DbBlackListState
implements MutableBlackListState {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final String BLACKLIST_INSTANCE_MESSAGE = "Blacklist process instance {}, due to previous errors.";
    private final ColumnFamily<DbLong, DbNil> blackListColumnFamily;
    private final DbLong processInstanceKey = new DbLong();
    private final BlacklistMetrics blacklistMetrics;

    public DbBlackListState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.blackListColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.BLACKLIST, transactionContext, (DbKey)this.processInstanceKey, (DbValue)DbNil.INSTANCE);
        this.blacklistMetrics = new BlacklistMetrics(partitionId);
    }

    private void blacklist(long key) {
        if (key >= 0L) {
            LOG.warn(BLACKLIST_INSTANCE_MESSAGE, (Object)key);
            this.processInstanceKey.wrapLong(key);
            this.blackListColumnFamily.insert((DbKey)this.processInstanceKey, (DbValue)DbNil.INSTANCE);
            this.blacklistMetrics.countBlacklistedInstance();
        }
    }

    private boolean isOnBlacklist(long key) {
        this.processInstanceKey.wrapLong(key);
        return this.blackListColumnFamily.exists((DbKey)this.processInstanceKey);
    }

    @Override
    public boolean isOnBlacklist(TypedRecord record) {
        long processInstanceKey;
        UnifiedRecordValue value = record.getValue();
        if (value instanceof ProcessInstanceRelated && (processInstanceKey = ((ProcessInstanceRelated)value).getProcessInstanceKey()) >= 0L) {
            return this.isOnBlacklist(processInstanceKey);
        }
        return false;
    }

    @Override
    public boolean tryToBlacklist(TypedRecord<?> typedRecord, Consumer<Long> onBlacklistingInstance) {
        UnifiedRecordValue value;
        Intent intent = typedRecord.getIntent();
        if (DbBlackListState.shouldBeBlacklisted(intent) && (value = typedRecord.getValue()) instanceof ProcessInstanceRelated) {
            long processInstanceKey = ((ProcessInstanceRelated)value).getProcessInstanceKey();
            this.blacklist(processInstanceKey);
            onBlacklistingInstance.accept(processInstanceKey);
        }
        return false;
    }

    @Override
    public void blacklistProcessInstance(long processInstanceKey) {
        this.blacklist(processInstanceKey);
    }

    public static boolean shouldBeBlacklisted(Intent intent) {
        if (intent instanceof ProcessInstanceRelatedIntent) {
            ProcessInstanceRelatedIntent processInstanceRelatedIntent = (ProcessInstanceRelatedIntent)intent;
            return processInstanceRelatedIntent.shouldBlacklistInstanceOnError();
        }
        return false;
    }
}

