/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.signal;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.immutable.SignalSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableSignalSubscriptionState;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import org.agrona.DirectBuffer;

public final class DbSignalSubscriptionState
implements MutableSignalSubscriptionState {
    private final DbString signalName;
    private final DbLong processDefinitionKey;
    private final DbCompositeKey<DbString, DbLong> signalNameAndProcessDefinitionKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, SignalSubscription> subscriptionsColumnFamily;
    private final SignalSubscription signalSubscription = new SignalSubscription();
    private final DbCompositeKey<DbLong, DbString> processDefinitionKeyAndSignalName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> subscriptionsOfProcessDefinitionKeyColumnFamily;

    public DbSignalSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.signalName = new DbString();
        this.processDefinitionKey = new DbLong();
        this.signalNameAndProcessDefinitionKey = new DbCompositeKey((DbKey)this.signalName, (DbKey)this.processDefinitionKey);
        this.subscriptionsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.SIGNAL_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.signalNameAndProcessDefinitionKey, (DbValue)this.signalSubscription);
        this.processDefinitionKeyAndSignalName = new DbCompositeKey((DbKey)this.processDefinitionKey, (DbKey)this.signalName);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.SIGNAL_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.processDefinitionKeyAndSignalName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void put(long key, SignalSubscriptionRecord subscription) {
        this.signalSubscription.setKey(key).setRecord(subscription);
        this.signalName.wrapBuffer(subscription.getSignalNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        this.subscriptionsColumnFamily.upsert(this.signalNameAndProcessDefinitionKey, (DbValue)this.signalSubscription);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.upsert(this.processDefinitionKeyAndSignalName, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void remove(long processDefinitionKey, DirectBuffer signalName) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.signalName.wrapBuffer(signalName);
        this.subscriptionsColumnFamily.deleteExisting(this.signalNameAndProcessDefinitionKey);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.deleteExisting(this.processDefinitionKeyAndSignalName);
    }

    @Override
    public boolean exists(SignalSubscriptionRecord subscription) {
        this.signalName.wrapBuffer(subscription.getSignalNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        return this.subscriptionsColumnFamily.exists(this.signalNameAndProcessDefinitionKey);
    }

    @Override
    public void visitBySignalName(DirectBuffer signalName, SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.signalName.wrapBuffer(signalName);
        this.subscriptionsColumnFamily.whileEqualPrefix((DbKey)this.signalName, (key, value) -> visitor.visit((SignalSubscription)((Object)value)));
    }

    @Override
    public void visitStartEventSubscriptionsByProcessDefinitionKey(long processDefinitionKey, SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.processDefinitionKey.wrapLong(processDefinitionKey);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.whileEqualPrefix((DbKey)this.processDefinitionKey, (key, value) -> {
            SignalSubscription subscription = (SignalSubscription)this.subscriptionsColumnFamily.get(this.signalNameAndProcessDefinitionKey);
            if (subscription != null) {
                visitor.visit(subscription);
            }
        });
    }
}

