/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableIntermediateThrowEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLink;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.JobWorkerElementTransformer;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.LinkEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;

public final class IntermediateThrowEventTransformer
implements ModelElementTransformer<IntermediateThrowEvent> {
    private final JobWorkerElementTransformer<IntermediateThrowEvent> jobWorkerElementTransformer = new JobWorkerElementTransformer<IntermediateThrowEvent>(IntermediateThrowEvent.class);

    @Override
    public Class<IntermediateThrowEvent> getType() {
        return IntermediateThrowEvent.class;
    }

    @Override
    public void transform(IntermediateThrowEvent element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableIntermediateThrowEvent throwEvent = process.getElementById(element.getId(), ExecutableIntermediateThrowEvent.class);
        throwEvent.setEventType(BpmnEventType.NONE);
        if (this.isMessageEvent(element)) {
            throwEvent.setEventType(BpmnEventType.MESSAGE);
            if (this.hasTaskDefinition(element)) {
                this.jobWorkerElementTransformer.transform(element, context);
            }
        } else if (this.isLinkEvent(element)) {
            this.transformLinkEventDefinition(element, context, throwEvent);
        } else if (this.isEscalationEvent(element)) {
            this.transformEscalationEventDefinition(element, context);
        }
    }

    private boolean isMessageEvent(IntermediateThrowEvent element) {
        return element.getEventDefinitions().stream().anyMatch(MessageEventDefinition.class::isInstance);
    }

    private boolean isLinkEvent(IntermediateThrowEvent element) {
        return element.getEventDefinitions().stream().anyMatch(LinkEventDefinition.class::isInstance);
    }

    private boolean isEscalationEvent(IntermediateThrowEvent element) {
        return element.getEventDefinitions().stream().anyMatch(EscalationEventDefinition.class::isInstance);
    }

    private boolean hasTaskDefinition(IntermediateThrowEvent element) {
        return element.getSingleExtensionElement(ZeebeTaskDefinition.class) != null;
    }

    private void transformLinkEventDefinition(IntermediateThrowEvent element, TransformContext context, ExecutableIntermediateThrowEvent executableThrowEventElement) {
        LinkEventDefinition eventDefinition = (LinkEventDefinition)element.getEventDefinitions().iterator().next();
        String name = eventDefinition.getName();
        ExecutableLink executableLink = context.getLink(name);
        executableThrowEventElement.setLink(executableLink);
        executableThrowEventElement.setEventType(BpmnEventType.LINK);
    }

    private void transformEscalationEventDefinition(IntermediateThrowEvent element, TransformContext context) {
        ExecutableProcess currentProcess = context.getCurrentProcess();
        ExecutableIntermediateThrowEvent executableElement = currentProcess.getElementById(element.getId(), ExecutableIntermediateThrowEvent.class);
        EscalationEventDefinition eventDefinition = (EscalationEventDefinition)element.getEventDefinitions().iterator().next();
        Escalation escalation = eventDefinition.getEscalation();
        ExecutableEscalation executableEscalation = context.getEscalation(escalation.getId());
        executableElement.setEscalation(executableEscalation);
        executableElement.setEventType(BpmnEventType.ESCALATION);
    }
}

