/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message;

import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.scheduling.ProcessingScheduleService;
import io.camunda.zeebe.stream.api.scheduling.Task;
import io.camunda.zeebe.stream.api.scheduling.TaskResult;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import java.time.Duration;
import org.agrona.collections.MutableInteger;

public final class MessageTimeToLiveChecker
implements Task {
    private static final MessageRecord EMPTY_DELETE_MESSAGE_COMMAND = new MessageRecord().setName("").setCorrelationKey("").setTimeToLive(-1L);
    private final Duration executionInterval;
    private final int batchLimit;
    private final boolean enableMessageTtlCheckerAsync;
    private final ProcessingScheduleService scheduleService;
    private final MessageState messageState;
    private long currentTimestamp = -1L;
    private MessageState.Index lastIndex;

    public MessageTimeToLiveChecker(Duration executionInterval, int batchLimit, boolean enableMessageTtlCheckerAsync, ProcessingScheduleService scheduleService, MessageState messageState) {
        this.executionInterval = executionInterval;
        this.batchLimit = batchLimit;
        this.enableMessageTtlCheckerAsync = enableMessageTtlCheckerAsync;
        this.messageState = messageState;
        this.scheduleService = scheduleService;
        this.lastIndex = null;
    }

    public TaskResult execute(TaskResultBuilder taskResultBuilder) {
        MutableInteger counter;
        boolean shouldContinueWhereLeftOff;
        if (this.currentTimestamp == -1L) {
            this.currentTimestamp = ActorClock.currentTimeMillis();
        }
        if (shouldContinueWhereLeftOff = this.messageState.visitMessagesWithDeadlineBeforeTimestamp(this.currentTimestamp, this.lastIndex, (arg_0, arg_1) -> this.lambda$execute$0(taskResultBuilder, counter = new MutableInteger(0), arg_0, arg_1))) {
            this.reschedule(Duration.ZERO);
        } else {
            this.lastIndex = null;
            this.currentTimestamp = -1L;
            this.reschedule(this.executionInterval);
        }
        return taskResultBuilder.build();
    }

    private void reschedule(Duration idleInterval) {
        if (this.enableMessageTtlCheckerAsync) {
            this.scheduleService.runDelayedAsync(idleInterval, (Task)this);
        } else {
            this.scheduleService.runDelayed(idleInterval, (Task)this);
        }
    }

    private /* synthetic */ boolean lambda$execute$0(TaskResultBuilder taskResultBuilder, MutableInteger counter, long deadline, long expiredMessageKey) {
        MessageState.Index newIndex = new MessageState.Index(expiredMessageKey, deadline);
        boolean wasIndexAlreadyVisitedLastTime = newIndex.equals(this.lastIndex);
        this.lastIndex = newIndex;
        if (wasIndexAlreadyVisitedLastTime) {
            return true;
        }
        boolean stillFitsInResult = taskResultBuilder.appendCommandRecord(expiredMessageKey, (Intent)MessageIntent.EXPIRE, (UnifiedRecordValue)EMPTY_DELETE_MESSAGE_COMMAND);
        return stillFitsInResult && counter.incrementAndGet() < this.batchLimit;
    }
}

