/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.distribution;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.state.distribution.CommandValueAndValueTypeWrapper;
import io.camunda.zeebe.engine.state.mutable.MutableDistributionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import org.agrona.collections.MutableBoolean;

public class DbDistributionState
implements MutableDistributionState {
    private final DbLong distributionKey = new DbLong();
    private final DbForeignKey<DbLong> fkDistribution = new DbForeignKey((DbKey)this.distributionKey, (Enum)ZbColumnFamilies.COMMAND_DISTRIBUTION_RECORD);
    private final DbInt partitionKey;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbInt> distributionPartitionKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbInt>, DbNil> pendingDistributionColumnFamily;
    private final CommandValueAndValueTypeWrapper commandValueAndValueTypeWrapper = new CommandValueAndValueTypeWrapper();
    private final ColumnFamily<DbLong, CommandValueAndValueTypeWrapper> commandDistributionRecordColumnFamily;

    public DbDistributionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.commandDistributionRecordColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.COMMAND_DISTRIBUTION_RECORD, transactionContext, (DbKey)this.distributionKey, (DbValue)this.commandValueAndValueTypeWrapper);
        this.partitionKey = new DbInt();
        this.distributionPartitionKey = new DbCompositeKey(this.fkDistribution, (DbKey)this.partitionKey);
        this.pendingDistributionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PENDING_DISTRIBUTION, transactionContext, this.distributionPartitionKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void addCommandDistribution(long distributionKey, CommandDistributionRecord commandDistributionRecord) {
        this.distributionKey.wrapLong(distributionKey);
        this.commandDistributionRecordColumnFamily.insert((DbKey)this.distributionKey, (DbValue)new CommandValueAndValueTypeWrapper().wrap(commandDistributionRecord));
    }

    @Override
    public void removeCommandDistribution(long distributionKey) {
        this.distributionKey.wrapLong(distributionKey);
        this.commandDistributionRecordColumnFamily.deleteIfExists((DbKey)this.distributionKey);
    }

    @Override
    public void addPendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.pendingDistributionColumnFamily.insert(this.distributionPartitionKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void removePendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.pendingDistributionColumnFamily.deleteExisting(this.distributionPartitionKey);
    }

    @Override
    public boolean hasPendingDistribution(long distributionKey) {
        this.distributionKey.wrapLong(distributionKey);
        MutableBoolean hasPending = new MutableBoolean();
        this.pendingDistributionColumnFamily.whileEqualPrefix((DbKey)this.distributionKey, (compositeKey, dbNil) -> {
            hasPending.set(true);
            return false;
        });
        return hasPending.get();
    }

    @Override
    public boolean hasPendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        return this.pendingDistributionColumnFamily.exists(this.distributionPartitionKey);
    }

    @Override
    public CommandDistributionRecord getCommandDistributionRecord(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        CommandValueAndValueTypeWrapper storedDistribution = (CommandValueAndValueTypeWrapper)this.commandDistributionRecordColumnFamily.get((DbKey)this.distributionKey);
        if (storedDistribution == null) {
            return null;
        }
        return new CommandDistributionRecord().setPartitionId(partition).setValueType(storedDistribution.getValueType()).setRecordValue(storedDistribution.getCommandValue());
    }
}

