/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment;

import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.StartEventSubscriptionManager;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionBehavior;
import io.camunda.zeebe.engine.processing.deployment.distribute.DeploymentDistributionCommandSender;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.DecisionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.FeatureFlags;
import java.util.List;
import org.agrona.DirectBuffer;

public final class DeploymentCreateProcessor
implements TypedRecordProcessor<DeploymentRecord> {
    private static final String COULD_NOT_CREATE_TIMER_MESSAGE = "Expected to create timer for start event, but encountered the following error: %s";
    private final DeploymentTransformer deploymentTransformer;
    private final ProcessState processState;
    private final DecisionState decisionState;
    private final TimerInstanceState timerInstanceState;
    private final CatchEventBehavior catchEventBehavior;
    private final KeyGenerator keyGenerator;
    private final ExpressionProcessor expressionProcessor;
    private final StateWriter stateWriter;
    private final StartEventSubscriptionManager startEventSubscriptionManager;
    private final DeploymentDistributionBehavior deploymentDistributionBehavior;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;

    public DeploymentCreateProcessor(ProcessingState processingState, BpmnBehaviors bpmnBehaviors, int partitionsCount, Writers writers, DeploymentDistributionCommandSender deploymentDistributionCommandSender, KeyGenerator keyGenerator, FeatureFlags featureFlags) {
        this.processState = processingState.getProcessState();
        this.decisionState = processingState.getDecisionState();
        this.timerInstanceState = processingState.getTimerState();
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.catchEventBehavior = bpmnBehaviors.catchEventBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.deploymentTransformer = new DeploymentTransformer(this.stateWriter, processingState, this.expressionProcessor, keyGenerator, featureFlags);
        this.startEventSubscriptionManager = new StartEventSubscriptionManager(processingState, keyGenerator);
        this.deploymentDistributionBehavior = new DeploymentDistributionBehavior(writers, partitionsCount, deploymentDistributionCommandSender);
    }

    @Override
    public void processRecord(TypedRecord<DeploymentRecord> command) {
        DeploymentRecord deploymentEvent = (DeploymentRecord)command.getValue();
        Either<Failure, Void> result = this.deploymentTransformer.transform(deploymentEvent);
        if (result.isLeft()) {
            throw new ResourceTransformationFailedException(((Failure)result.getLeft()).getMessage());
        }
        try {
            this.createTimerIfTimerStartEvent(command);
        }
        catch (RuntimeException e) {
            this.processState.clearCache();
            String reason = String.format(COULD_NOT_CREATE_TIMER_MESSAGE, e.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.PROCESSING_ERROR, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.PROCESSING_ERROR, reason);
            return;
        }
        long key = this.keyGenerator.nextKey();
        this.responseWriter.writeEventOnCommand(key, (Intent)DeploymentIntent.CREATED, (UnpackedObject)deploymentEvent, command);
        this.stateWriter.appendFollowUpEvent(key, (Intent)DeploymentIntent.CREATED, (RecordValue)deploymentEvent);
        this.deploymentDistributionBehavior.distributeDeployment(deploymentEvent, key);
        this.startEventSubscriptionManager.tryReOpenStartEventSubscription(deploymentEvent, this.stateWriter);
    }

    @Override
    public TypedRecordProcessor.ProcessingError tryHandleError(TypedRecord<DeploymentRecord> command, Throwable error) {
        if (((DeploymentRecord)command.getValue()).hasBpmnResources()) {
            this.processState.clearCache();
        }
        if (((DeploymentRecord)command.getValue()).hasDmnResources()) {
            this.decisionState.clearCache();
        }
        if (error instanceof ResourceTransformationFailedException) {
            ResourceTransformationFailedException exception = (ResourceTransformationFailedException)error;
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_ARGUMENT, exception.getMessage());
            return TypedRecordProcessor.ProcessingError.EXPECTED_ERROR;
        }
        return TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR;
    }

    private void createTimerIfTimerStartEvent(TypedRecord<DeploymentRecord> record) {
        for (ProcessMetadata processMetadata : ((DeploymentRecord)record.getValue()).processesMetadata()) {
            if (processMetadata.isDuplicate()) continue;
            List<ExecutableStartEvent> startEvents = this.processState.getProcessByKey(processMetadata.getKey()).getProcess().getStartEvents();
            this.unsubscribeFromPreviousTimers(processMetadata);
            this.subscribeToTimerStartEventIfExists(processMetadata, startEvents);
        }
    }

    private void subscribeToTimerStartEventIfExists(ProcessMetadata processMetadata, List<ExecutableStartEvent> startEvents) {
        for (ExecutableCatchEventElement executableCatchEventElement : startEvents) {
            if (!executableCatchEventElement.isTimer()) continue;
            long scopeKey = -1L;
            Either<Failure, Timer> timerOrError = executableCatchEventElement.getTimerFactory().apply(this.expressionProcessor, -1L);
            if (timerOrError.isLeft()) {
                throw new ExpressionProcessor.EvaluationException(((Failure)timerOrError.getLeft()).getMessage());
            }
            this.catchEventBehavior.subscribeToTimerEvent(-1L, -1L, processMetadata.getKey(), executableCatchEventElement.getId(), (Timer)timerOrError.get());
        }
    }

    private void unsubscribeFromPreviousTimers(ProcessMetadata processRecord) {
        this.timerInstanceState.forEachTimerForElementInstance(-1L, timer -> this.unsubscribeFromPreviousTimer(processRecord, (TimerInstance)((Object)timer)));
    }

    private void unsubscribeFromPreviousTimer(ProcessMetadata processMetadata, TimerInstance timer) {
        DirectBuffer timerBpmnId = this.processState.getProcessByKey(timer.getProcessDefinitionKey()).getBpmnProcessId();
        if (timerBpmnId.equals(processMetadata.getBpmnProcessIdBuffer())) {
            this.catchEventBehavior.unsubscribeFromTimerEvent(timer);
        }
    }

    private static final class ResourceTransformationFailedException
    extends RuntimeException {
        private ResourceTransformationFailedException(String message) {
            super(message);
        }
    }
}

