/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.common.EventHandle;
import io.camunda.zeebe.engine.processing.job.JobBackoffChecker;
import io.camunda.zeebe.engine.processing.job.JobBatchActivateProcessor;
import io.camunda.zeebe.engine.processing.job.JobCancelProcessor;
import io.camunda.zeebe.engine.processing.job.JobCompleteProcessor;
import io.camunda.zeebe.engine.processing.job.JobFailProcessor;
import io.camunda.zeebe.engine.processing.job.JobRecurProcessor;
import io.camunda.zeebe.engine.processing.job.JobThrowErrorProcessor;
import io.camunda.zeebe.engine.processing.job.JobTimeOutProcessor;
import io.camunda.zeebe.engine.processing.job.JobTimeoutTrigger;
import io.camunda.zeebe.engine.processing.job.JobUpdateRetriesProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.mutable.MutableJobState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;

public final class JobEventProcessors {
    public static void addJobProcessors(TypedRecordProcessors typedRecordProcessors, MutableProcessingState processingState, BpmnBehaviors bpmnBehaviors, Writers writers, JobMetrics jobMetrics) {
        MutableJobState jobState = processingState.getJobState();
        KeyGenerator keyGenerator = processingState.getKeyGenerator();
        EventHandle eventHandle = new EventHandle(keyGenerator, processingState.getEventScopeInstanceState(), writers, processingState.getProcessState(), bpmnBehaviors.eventTriggerBehavior(), bpmnBehaviors.stateBehavior());
        JobBackoffChecker jobBackoffChecker = new JobBackoffChecker(jobState);
        typedRecordProcessors.onCommand(ValueType.JOB, (Intent)JobIntent.COMPLETE, new JobCompleteProcessor(processingState, jobMetrics, eventHandle)).onCommand(ValueType.JOB, (Intent)JobIntent.FAIL, new JobFailProcessor(processingState, writers, processingState.getKeyGenerator(), jobMetrics, jobBackoffChecker, bpmnBehaviors.variableBehavior())).onCommand(ValueType.JOB, (Intent)JobIntent.THROW_ERROR, new JobThrowErrorProcessor(processingState, bpmnBehaviors.eventPublicationBehavior(), keyGenerator, jobMetrics)).onCommand(ValueType.JOB, (Intent)JobIntent.TIME_OUT, new JobTimeOutProcessor(processingState, writers, jobMetrics)).onCommand(ValueType.JOB, (Intent)JobIntent.UPDATE_RETRIES, new JobUpdateRetriesProcessor(processingState)).onCommand(ValueType.JOB, (Intent)JobIntent.CANCEL, new JobCancelProcessor(processingState, jobMetrics)).onCommand(ValueType.JOB, (Intent)JobIntent.RECUR_AFTER_BACKOFF, new JobRecurProcessor(processingState, writers)).onCommand(ValueType.JOB_BATCH, (Intent)JobBatchIntent.ACTIVATE, new JobBatchActivateProcessor(writers, processingState, processingState.getKeyGenerator(), jobMetrics)).withListener(new JobTimeoutTrigger(jobState)).withListener(jobBackoffChecker);
    }
}

