/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.PendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.mutable.MutablePendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class DbProcessMessageSubscriptionState
implements MutableProcessMessageSubscriptionState,
MutablePendingProcessMessageSubscriptionState,
StreamProcessorLifecycleAware {
    private final DbLong elementInstanceKey;
    private final DbString messageName;
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName;
    private final ProcessMessageSubscription processMessageSubscription;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, ProcessMessageSubscription> subscriptionColumnFamily;
    private final PendingProcessMessageSubscriptionState transientState = new PendingProcessMessageSubscriptionState(this);

    public DbProcessMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.elementInstanceKey = new DbLong();
        this.messageName = new DbString();
        this.elementKeyAndMessageName = new DbCompositeKey((DbKey)this.elementInstanceKey, (DbKey)this.messageName);
        this.processMessageSubscription = new ProcessMessageSubscription();
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, (DbValue)this.processMessageSubscription);
    }

    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.subscriptionColumnFamily.forEach(subscription -> {
            if (subscription.isOpening() || subscription.isClosing()) {
                this.transientState.add(subscription.getRecord());
            }
        });
    }

    @Override
    public void put(long key, ProcessMessageSubscriptionRecord record) {
        this.wrapSubscriptionKeys(record.getElementInstanceKey(), record.getMessageNameBuffer());
        this.processMessageSubscription.reset();
        this.processMessageSubscription.setKey(key).setRecord(record);
        this.subscriptionColumnFamily.insert(this.elementKeyAndMessageName, (DbValue)this.processMessageSubscription);
        this.transientState.add(record);
    }

    @Override
    public void updateToOpeningState(ProcessMessageSubscriptionRecord record) {
        this.update(record, (ProcessMessageSubscription s) -> s.setRecord(record).setOpening());
        this.transientState.add(record);
    }

    @Override
    public void updateToOpenedState(ProcessMessageSubscriptionRecord record) {
        this.update(record, (ProcessMessageSubscription s) -> s.setRecord(record).setOpened());
        this.transientState.remove(record);
    }

    @Override
    public void updateToClosingState(ProcessMessageSubscriptionRecord record) {
        this.update(record, (ProcessMessageSubscription s) -> s.setRecord(record).setClosing());
        this.transientState.add(record);
    }

    @Override
    public boolean remove(long elementInstanceKey, DirectBuffer messageName) {
        boolean found;
        ProcessMessageSubscription subscription = this.getSubscription(elementInstanceKey, messageName);
        boolean bl = found = subscription != null;
        if (found) {
            this.remove(subscription);
        }
        return found;
    }

    @Override
    public ProcessMessageSubscription getSubscription(long elementInstanceKey, DirectBuffer messageName) {
        this.wrapSubscriptionKeys(elementInstanceKey, messageName);
        return (ProcessMessageSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
    }

    @Override
    public void visitElementSubscriptions(long elementInstanceKey, ProcessMessageSubscriptionState.ProcessMessageSubscriptionVisitor visitor) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.subscriptionColumnFamily.whileEqualPrefix((DbKey)this.elementInstanceKey, (compositeKey, subscription) -> visitor.visit((ProcessMessageSubscription)((Object)subscription)));
    }

    @Override
    public boolean existSubscriptionForElementInstance(long elementInstanceKey, DirectBuffer messageName) {
        this.wrapSubscriptionKeys(elementInstanceKey, messageName);
        return this.subscriptionColumnFamily.exists(this.elementKeyAndMessageName);
    }

    @Override
    public void visitSubscriptionBefore(long deadline, ProcessMessageSubscriptionState.ProcessMessageSubscriptionVisitor visitor) {
        this.transientState.visitSubscriptionBefore(deadline, visitor);
    }

    @Override
    public void updateSentTime(ProcessMessageSubscriptionRecord record, long commandSentTime) {
        this.transientState.updateSentTime(record, commandSentTime);
    }

    private void update(ProcessMessageSubscriptionRecord record, Consumer<ProcessMessageSubscription> modifier) {
        ProcessMessageSubscription subscription = this.getSubscription(record.getElementInstanceKey(), record.getMessageNameBuffer());
        if (subscription == null) {
            return;
        }
        this.update(subscription, modifier);
    }

    private void update(ProcessMessageSubscription subscription, Consumer<ProcessMessageSubscription> modifier) {
        modifier.accept(subscription);
        this.wrapSubscriptionKeys(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageNameBuffer());
        this.subscriptionColumnFamily.update(this.elementKeyAndMessageName, (DbValue)subscription);
    }

    private void remove(ProcessMessageSubscription subscription) {
        this.wrapSubscriptionKeys(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageNameBuffer());
        this.subscriptionColumnFamily.deleteExisting(this.elementKeyAndMessageName);
        this.transientState.remove(subscription.getRecord());
    }

    private void wrapSubscriptionKeys(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
    }
}

